/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.SourceDetail;

@SdkInternalApi
public class SourceDetailMarshaller {
    private static final MarshallingInfo<String> EVENTSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventSource").build();
    private static final MarshallingInfo<String> MESSAGETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageType").build();
    private static final MarshallingInfo<String> MAXIMUMEXECUTIONFREQUENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumExecutionFrequency").build();
    private static final SourceDetailMarshaller INSTANCE = new SourceDetailMarshaller();

    public static SourceDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SourceDetail sourceDetail, ProtocolMarshaller protocolMarshaller) {
        if (sourceDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sourceDetail.eventSourceString(), EVENTSOURCE_BINDING);
            protocolMarshaller.marshall((Object)sourceDetail.messageTypeString(), MESSAGETYPE_BINDING);
            protocolMarshaller.marshall((Object)sourceDetail.maximumExecutionFrequencyString(), MAXIMUMEXECUTIONFREQUENCY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

