/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.Scope;

@SdkInternalApi
public class ScopeMarshaller {
    private static final MarshallingInfo<List> COMPLIANCERESOURCETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceResourceTypes").build();
    private static final MarshallingInfo<String> TAGKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagKey").build();
    private static final MarshallingInfo<String> TAGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagValue").build();
    private static final MarshallingInfo<String> COMPLIANCERESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceResourceId").build();
    private static final ScopeMarshaller INSTANCE = new ScopeMarshaller();

    public static ScopeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Scope scope, ProtocolMarshaller protocolMarshaller) {
        if (scope == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(scope.complianceResourceTypes(), COMPLIANCERESOURCETYPES_BINDING);
            protocolMarshaller.marshall((Object)scope.tagKey(), TAGKEY_BINDING);
            protocolMarshaller.marshall((Object)scope.tagValue(), TAGVALUE_BINDING);
            protocolMarshaller.marshall((Object)scope.complianceResourceId(), COMPLIANCERESOURCEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

