/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.config.model.Relationship;

public class RelationshipUnmarshaller
implements Unmarshaller<Relationship, JsonUnmarshallerContext> {
    private static final RelationshipUnmarshaller INSTANCE = new RelationshipUnmarshaller();

    public Relationship unmarshall(JsonUnmarshallerContext context) throws Exception {
        Relationship.Builder relationshipBuilder = Relationship.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    relationshipBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceId", targetDepth)) {
                    context.nextToken();
                    relationshipBuilder.resourceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceName", targetDepth)) {
                    context.nextToken();
                    relationshipBuilder.resourceName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("relationshipName", targetDepth)) {
                    context.nextToken();
                    relationshipBuilder.relationshipName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Relationship)relationshipBuilder.build();
    }

    public static RelationshipUnmarshaller getInstance() {
        return INSTANCE;
    }
}

