/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.DeliveryChannel;

@SdkInternalApi
public class DeliveryChannelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> S3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3BucketName").build();
    private static final MarshallingInfo<String> S3KEYPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3KeyPrefix").build();
    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snsTopicARN").build();
    private static final MarshallingInfo<StructuredPojo> CONFIGSNAPSHOTDELIVERYPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configSnapshotDeliveryProperties").build();
    private static final DeliveryChannelMarshaller INSTANCE = new DeliveryChannelMarshaller();

    public static DeliveryChannelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeliveryChannel deliveryChannel, ProtocolMarshaller protocolMarshaller) {
        if (deliveryChannel == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deliveryChannel.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)deliveryChannel.s3BucketName(), S3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)deliveryChannel.s3KeyPrefix(), S3KEYPREFIX_BINDING);
            protocolMarshaller.marshall((Object)deliveryChannel.snsTopicARN(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall((Object)deliveryChannel.configSnapshotDeliveryProperties(), CONFIGSNAPSHOTDELIVERYPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

