/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.ConfigurationItem;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse;

public final class GetResourceConfigHistoryPaginator
implements SdkIterable<GetResourceConfigHistoryResponse> {
    private final ConfigClient client;
    private final GetResourceConfigHistoryRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetResourceConfigHistoryPaginator(ConfigClient client, GetResourceConfigHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetResourceConfigHistoryResponseFetcher();
    }

    public Iterator<GetResourceConfigHistoryResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ConfigurationItem> configurationItems() {
        Function<GetResourceConfigHistoryResponse, Iterator> getIterator = response -> response != null ? response.configurationItems().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class GetResourceConfigHistoryResponseFetcher
    implements NextPageFetcher<GetResourceConfigHistoryResponse> {
        private GetResourceConfigHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceConfigHistoryResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetResourceConfigHistoryResponse nextPage(GetResourceConfigHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetResourceConfigHistoryPaginator.this.client.getResourceConfigHistory(GetResourceConfigHistoryPaginator.this.firstRequest);
            }
            return GetResourceConfigHistoryPaginator.this.client.getResourceConfigHistory((GetResourceConfigHistoryRequest)((Object)GetResourceConfigHistoryPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

