/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.model.ComplianceTypesCopier;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ConfigRuleNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeComplianceByConfigRuleRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DescribeComplianceByConfigRuleRequest> {
    private final List<String> configRuleNames;
    private final List<String> complianceTypes;
    private final String nextToken;

    private DescribeComplianceByConfigRuleRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleNames = builder.configRuleNames;
        this.complianceTypes = builder.complianceTypes;
        this.nextToken = builder.nextToken;
    }

    public List<String> configRuleNames() {
        return this.configRuleNames;
    }

    public List<ComplianceType> complianceTypes() {
        return TypeConverter.convert(this.complianceTypes, ComplianceType::fromValue);
    }

    public List<String> complianceTypesStrings() {
        return this.complianceTypes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComplianceByConfigRuleRequest)) {
            return false;
        }
        DescribeComplianceByConfigRuleRequest other = (DescribeComplianceByConfigRuleRequest)((Object)obj);
        return Objects.equals(this.configRuleNames(), other.configRuleNames()) && Objects.equals(this.complianceTypesStrings(), other.complianceTypesStrings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeComplianceByConfigRuleRequest").add("ConfigRuleNames", this.configRuleNames()).add("ComplianceTypes", this.complianceTypesStrings()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleNames": {
                return Optional.of(clazz.cast(this.configRuleNames()));
            }
            case "ComplianceTypes": {
                return Optional.of(clazz.cast(this.complianceTypesStrings()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private List<String> configRuleNames;
        private List<String> complianceTypes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComplianceByConfigRuleRequest model) {
            this.configRuleNames(model.configRuleNames);
            this.complianceTypes(model.complianceTypes);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getConfigRuleNames() {
            return this.configRuleNames;
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String ... configRuleNames) {
            this.configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
        }

        public final Collection<String> getComplianceTypes() {
            return this.complianceTypes;
        }

        @Override
        public final Builder complianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(String ... complianceTypes) {
            this.complianceTypes(Arrays.asList(complianceTypes));
            return this;
        }

        public final void setComplianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeComplianceByConfigRuleRequest build() {
            return new DescribeComplianceByConfigRuleRequest(this);
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    CopyableBuilder<Builder, DescribeComplianceByConfigRuleRequest> {
        public Builder configRuleNames(Collection<String> var1);

        public Builder configRuleNames(String ... var1);

        public Builder complianceTypes(Collection<String> var1);

        public Builder complianceTypes(String ... var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

