/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ConfigExportDeliveryInfo;
import software.amazon.awssdk.services.config.model.ConfigStreamDeliveryInfo;
import software.amazon.awssdk.services.config.transform.DeliveryChannelStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeliveryChannelStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, DeliveryChannelStatus> {
    private final String name;
    private final ConfigExportDeliveryInfo configSnapshotDeliveryInfo;
    private final ConfigExportDeliveryInfo configHistoryDeliveryInfo;
    private final ConfigStreamDeliveryInfo configStreamDeliveryInfo;

    private DeliveryChannelStatus(BuilderImpl builder) {
        this.name = builder.name;
        this.configSnapshotDeliveryInfo = builder.configSnapshotDeliveryInfo;
        this.configHistoryDeliveryInfo = builder.configHistoryDeliveryInfo;
        this.configStreamDeliveryInfo = builder.configStreamDeliveryInfo;
    }

    public String name() {
        return this.name;
    }

    public ConfigExportDeliveryInfo configSnapshotDeliveryInfo() {
        return this.configSnapshotDeliveryInfo;
    }

    public ConfigExportDeliveryInfo configHistoryDeliveryInfo() {
        return this.configHistoryDeliveryInfo;
    }

    public ConfigStreamDeliveryInfo configStreamDeliveryInfo() {
        return this.configStreamDeliveryInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.configSnapshotDeliveryInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.configHistoryDeliveryInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.configStreamDeliveryInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryChannelStatus)) {
            return false;
        }
        DeliveryChannelStatus other = (DeliveryChannelStatus)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.configSnapshotDeliveryInfo(), other.configSnapshotDeliveryInfo()) && Objects.equals(this.configHistoryDeliveryInfo(), other.configHistoryDeliveryInfo()) && Objects.equals(this.configStreamDeliveryInfo(), other.configStreamDeliveryInfo());
    }

    public String toString() {
        return ToString.builder((String)"DeliveryChannelStatus").add("Name", (Object)this.name()).add("ConfigSnapshotDeliveryInfo", (Object)this.configSnapshotDeliveryInfo()).add("ConfigHistoryDeliveryInfo", (Object)this.configHistoryDeliveryInfo()).add("ConfigStreamDeliveryInfo", (Object)this.configStreamDeliveryInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "configSnapshotDeliveryInfo": {
                return Optional.of(clazz.cast(this.configSnapshotDeliveryInfo()));
            }
            case "configHistoryDeliveryInfo": {
                return Optional.of(clazz.cast(this.configHistoryDeliveryInfo()));
            }
            case "configStreamDeliveryInfo": {
                return Optional.of(clazz.cast(this.configStreamDeliveryInfo()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeliveryChannelStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private ConfigExportDeliveryInfo configSnapshotDeliveryInfo;
        private ConfigExportDeliveryInfo configHistoryDeliveryInfo;
        private ConfigStreamDeliveryInfo configStreamDeliveryInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryChannelStatus model) {
            this.name(model.name);
            this.configSnapshotDeliveryInfo(model.configSnapshotDeliveryInfo);
            this.configHistoryDeliveryInfo(model.configHistoryDeliveryInfo);
            this.configStreamDeliveryInfo(model.configStreamDeliveryInfo);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ConfigExportDeliveryInfo.Builder getConfigSnapshotDeliveryInfo() {
            return this.configSnapshotDeliveryInfo != null ? this.configSnapshotDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configSnapshotDeliveryInfo(ConfigExportDeliveryInfo configSnapshotDeliveryInfo) {
            this.configSnapshotDeliveryInfo = configSnapshotDeliveryInfo;
            return this;
        }

        public final void setConfigSnapshotDeliveryInfo(ConfigExportDeliveryInfo.BuilderImpl configSnapshotDeliveryInfo) {
            this.configSnapshotDeliveryInfo = configSnapshotDeliveryInfo != null ? configSnapshotDeliveryInfo.build() : null;
        }

        public final ConfigExportDeliveryInfo.Builder getConfigHistoryDeliveryInfo() {
            return this.configHistoryDeliveryInfo != null ? this.configHistoryDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configHistoryDeliveryInfo(ConfigExportDeliveryInfo configHistoryDeliveryInfo) {
            this.configHistoryDeliveryInfo = configHistoryDeliveryInfo;
            return this;
        }

        public final void setConfigHistoryDeliveryInfo(ConfigExportDeliveryInfo.BuilderImpl configHistoryDeliveryInfo) {
            this.configHistoryDeliveryInfo = configHistoryDeliveryInfo != null ? configHistoryDeliveryInfo.build() : null;
        }

        public final ConfigStreamDeliveryInfo.Builder getConfigStreamDeliveryInfo() {
            return this.configStreamDeliveryInfo != null ? this.configStreamDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configStreamDeliveryInfo(ConfigStreamDeliveryInfo configStreamDeliveryInfo) {
            this.configStreamDeliveryInfo = configStreamDeliveryInfo;
            return this;
        }

        public final void setConfigStreamDeliveryInfo(ConfigStreamDeliveryInfo.BuilderImpl configStreamDeliveryInfo) {
            this.configStreamDeliveryInfo = configStreamDeliveryInfo != null ? configStreamDeliveryInfo.build() : null;
        }

        public DeliveryChannelStatus build() {
            return new DeliveryChannelStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeliveryChannelStatus> {
        public Builder name(String var1);

        public Builder configSnapshotDeliveryInfo(ConfigExportDeliveryInfo var1);

        default public Builder configSnapshotDeliveryInfo(Consumer<ConfigExportDeliveryInfo.Builder> configSnapshotDeliveryInfo) {
            return this.configSnapshotDeliveryInfo((ConfigExportDeliveryInfo)((ConfigExportDeliveryInfo.Builder)ConfigExportDeliveryInfo.builder().apply(configSnapshotDeliveryInfo)).build());
        }

        public Builder configHistoryDeliveryInfo(ConfigExportDeliveryInfo var1);

        default public Builder configHistoryDeliveryInfo(Consumer<ConfigExportDeliveryInfo.Builder> configHistoryDeliveryInfo) {
            return this.configHistoryDeliveryInfo((ConfigExportDeliveryInfo)((ConfigExportDeliveryInfo.Builder)ConfigExportDeliveryInfo.builder().apply(configHistoryDeliveryInfo)).build());
        }

        public Builder configStreamDeliveryInfo(ConfigStreamDeliveryInfo var1);

        default public Builder configStreamDeliveryInfo(Consumer<ConfigStreamDeliveryInfo.Builder> configStreamDeliveryInfo) {
            return this.configStreamDeliveryInfo((ConfigStreamDeliveryInfo)((ConfigStreamDeliveryInfo.Builder)ConfigStreamDeliveryInfo.builder().apply(configStreamDeliveryInfo)).build());
        }
    }
}

