/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.RecordingGroup;
import software.amazon.awssdk.services.config.transform.ConfigurationRecorderMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigurationRecorder
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigurationRecorder> {
    private final String name;
    private final String roleARN;
    private final RecordingGroup recordingGroup;

    private ConfigurationRecorder(BuilderImpl builder) {
        this.name = builder.name;
        this.roleARN = builder.roleARN;
        this.recordingGroup = builder.recordingGroup;
    }

    public String name() {
        return this.name;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public RecordingGroup recordingGroup() {
        return this.recordingGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingGroup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorder)) {
            return false;
        }
        ConfigurationRecorder other = (ConfigurationRecorder)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.recordingGroup(), other.recordingGroup());
    }

    public String toString() {
        return ToString.builder((String)"ConfigurationRecorder").add("Name", (Object)this.name()).add("RoleARN", (Object)this.roleARN()).add("RecordingGroup", (Object)this.recordingGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "roleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "recordingGroup": {
                return Optional.of(clazz.cast(this.recordingGroup()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationRecorderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String roleARN;
        private RecordingGroup recordingGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorder model) {
            this.name(model.name);
            this.roleARN(model.roleARN);
            this.recordingGroup(model.recordingGroup);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final RecordingGroup.Builder getRecordingGroup() {
            return this.recordingGroup != null ? this.recordingGroup.toBuilder() : null;
        }

        @Override
        public final Builder recordingGroup(RecordingGroup recordingGroup) {
            this.recordingGroup = recordingGroup;
            return this;
        }

        public final void setRecordingGroup(RecordingGroup.BuilderImpl recordingGroup) {
            this.recordingGroup = recordingGroup != null ? recordingGroup.build() : null;
        }

        public ConfigurationRecorder build() {
            return new ConfigurationRecorder(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigurationRecorder> {
        public Builder name(String var1);

        public Builder roleARN(String var1);

        public Builder recordingGroup(RecordingGroup var1);

        default public Builder recordingGroup(Consumer<RecordingGroup.Builder> recordingGroup) {
            return this.recordingGroup((RecordingGroup)((RecordingGroup.Builder)RecordingGroup.builder().apply(recordingGroup)).build());
        }
    }
}

