/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceSummary;
import software.amazon.awssdk.services.config.transform.ComplianceSummaryByResourceTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComplianceSummaryByResourceType
implements StructuredPojo,
ToCopyableBuilder<Builder, ComplianceSummaryByResourceType> {
    private final String resourceType;
    private final ComplianceSummary complianceSummary;

    private ComplianceSummaryByResourceType(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.complianceSummary = builder.complianceSummary;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public ComplianceSummary complianceSummary() {
        return this.complianceSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceSummaryByResourceType)) {
            return false;
        }
        ComplianceSummaryByResourceType other = (ComplianceSummaryByResourceType)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.complianceSummary(), other.complianceSummary());
    }

    public String toString() {
        return ToString.builder((String)"ComplianceSummaryByResourceType").add("ResourceType", (Object)this.resourceType()).add("ComplianceSummary", (Object)this.complianceSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceType()));
            }
            case "ComplianceSummary": {
                return Optional.of(clazz.cast(this.complianceSummary()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceSummaryByResourceTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private ComplianceSummary complianceSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceSummaryByResourceType model) {
            this.resourceType(model.resourceType);
            this.complianceSummary(model.complianceSummary);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final ComplianceSummary.Builder getComplianceSummary() {
            return this.complianceSummary != null ? this.complianceSummary.toBuilder() : null;
        }

        @Override
        public final Builder complianceSummary(ComplianceSummary complianceSummary) {
            this.complianceSummary = complianceSummary;
            return this;
        }

        public final void setComplianceSummary(ComplianceSummary.BuilderImpl complianceSummary) {
            this.complianceSummary = complianceSummary != null ? complianceSummary.build() : null;
        }

        public ComplianceSummaryByResourceType build() {
            return new ComplianceSummaryByResourceType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComplianceSummaryByResourceType> {
        public Builder resourceType(String var1);

        public Builder complianceSummary(ComplianceSummary var1);

        default public Builder complianceSummary(Consumer<ComplianceSummary.Builder> complianceSummary) {
            return this.complianceSummary((ComplianceSummary)((ComplianceSummary.Builder)ComplianceSummary.builder().apply(complianceSummary)).build());
        }
    }
}

