/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.Compliance;

@SdkInternalApi
public class ComplianceMarshaller {
    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").build();
    private static final MarshallingInfo<StructuredPojo> COMPLIANCECONTRIBUTORCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceContributorCount").build();
    private static final ComplianceMarshaller INSTANCE = new ComplianceMarshaller();

    public static ComplianceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Compliance compliance, ProtocolMarshaller protocolMarshaller) {
        if (compliance == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)compliance.complianceTypeString(), COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)compliance.complianceContributorCount(), COMPLIANCECONTRIBUTORCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

