/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ResourceCount;
import software.amazon.awssdk.services.config.model.ResourceCountsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDiscoveredResourceCountsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, GetDiscoveredResourceCountsResponse> {
    private final Long totalDiscoveredResources;
    private final List<ResourceCount> resourceCounts;
    private final String nextToken;

    private GetDiscoveredResourceCountsResponse(BuilderImpl builder) {
        super(builder);
        this.totalDiscoveredResources = builder.totalDiscoveredResources;
        this.resourceCounts = builder.resourceCounts;
        this.nextToken = builder.nextToken;
    }

    public Long totalDiscoveredResources() {
        return this.totalDiscoveredResources;
    }

    public List<ResourceCount> resourceCounts() {
        return this.resourceCounts;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalDiscoveredResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiscoveredResourceCountsResponse)) {
            return false;
        }
        GetDiscoveredResourceCountsResponse other = (GetDiscoveredResourceCountsResponse)((Object)obj);
        return Objects.equals(this.totalDiscoveredResources(), other.totalDiscoveredResources()) && Objects.equals(this.resourceCounts(), other.resourceCounts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.totalDiscoveredResources() != null) {
            sb.append("TotalDiscoveredResources: ").append(this.totalDiscoveredResources()).append(",");
        }
        if (this.resourceCounts() != null) {
            sb.append("ResourceCounts: ").append(this.resourceCounts()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "totalDiscoveredResources": {
                return Optional.of(clazz.cast(this.totalDiscoveredResources()));
            }
            case "resourceCounts": {
                return Optional.of(clazz.cast(this.resourceCounts()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private Long totalDiscoveredResources;
        private List<ResourceCount> resourceCounts;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiscoveredResourceCountsResponse model) {
            this.totalDiscoveredResources(model.totalDiscoveredResources);
            this.resourceCounts(model.resourceCounts);
            this.nextToken(model.nextToken);
        }

        public final Long getTotalDiscoveredResources() {
            return this.totalDiscoveredResources;
        }

        @Override
        public final Builder totalDiscoveredResources(Long totalDiscoveredResources) {
            this.totalDiscoveredResources = totalDiscoveredResources;
            return this;
        }

        public final void setTotalDiscoveredResources(Long totalDiscoveredResources) {
            this.totalDiscoveredResources = totalDiscoveredResources;
        }

        public final Collection<ResourceCount.Builder> getResourceCounts() {
            return this.resourceCounts != null ? (Collection)this.resourceCounts.stream().map(ResourceCount::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceCounts(Collection<ResourceCount> resourceCounts) {
            this.resourceCounts = ResourceCountsCopier.copy(resourceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceCounts(ResourceCount ... resourceCounts) {
            this.resourceCounts(Arrays.asList(resourceCounts));
            return this;
        }

        public final void setResourceCounts(Collection<ResourceCount.BuilderImpl> resourceCounts) {
            this.resourceCounts = ResourceCountsCopier.copyFromBuilder(resourceCounts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetDiscoveredResourceCountsResponse build() {
            return new GetDiscoveredResourceCountsResponse(this);
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    CopyableBuilder<Builder, GetDiscoveredResourceCountsResponse> {
        public Builder totalDiscoveredResources(Long var1);

        public Builder resourceCounts(Collection<ResourceCount> var1);

        public Builder resourceCounts(ResourceCount ... var1);

        public Builder nextToken(String var1);
    }
}

