/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.MaximumExecutionFrequency;
import software.amazon.awssdk.services.config.transform.ConfigSnapshotDeliveryPropertiesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigSnapshotDeliveryProperties
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigSnapshotDeliveryProperties> {
    private final String deliveryFrequency;

    private ConfigSnapshotDeliveryProperties(BuilderImpl builder) {
        this.deliveryFrequency = builder.deliveryFrequency;
    }

    public MaximumExecutionFrequency deliveryFrequency() {
        return MaximumExecutionFrequency.fromValue(this.deliveryFrequency);
    }

    public String deliveryFrequencyString() {
        return this.deliveryFrequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryFrequencyString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigSnapshotDeliveryProperties)) {
            return false;
        }
        ConfigSnapshotDeliveryProperties other = (ConfigSnapshotDeliveryProperties)obj;
        return Objects.equals(this.deliveryFrequencyString(), other.deliveryFrequencyString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deliveryFrequencyString() != null) {
            sb.append("DeliveryFrequency: ").append(this.deliveryFrequencyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deliveryFrequency": {
                return Optional.of(clazz.cast(this.deliveryFrequencyString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigSnapshotDeliveryPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryFrequency;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigSnapshotDeliveryProperties model) {
            this.deliveryFrequency(model.deliveryFrequency);
        }

        public final String getDeliveryFrequency() {
            return this.deliveryFrequency;
        }

        @Override
        public final Builder deliveryFrequency(String deliveryFrequency) {
            this.deliveryFrequency = deliveryFrequency;
            return this;
        }

        @Override
        public final Builder deliveryFrequency(MaximumExecutionFrequency deliveryFrequency) {
            this.deliveryFrequency(deliveryFrequency.toString());
            return this;
        }

        public final void setDeliveryFrequency(String deliveryFrequency) {
            this.deliveryFrequency = deliveryFrequency;
        }

        public ConfigSnapshotDeliveryProperties build() {
            return new ConfigSnapshotDeliveryProperties(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigSnapshotDeliveryProperties> {
        public Builder deliveryFrequency(String var1);

        public Builder deliveryFrequency(MaximumExecutionFrequency var1);
    }
}

