/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.Relationship;

@SdkInternalApi
public class RelationshipMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceId").build();
    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceName").build();
    private static final MarshallingInfo<String> RELATIONSHIPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relationshipName").build();
    private static final RelationshipMarshaller INSTANCE = new RelationshipMarshaller();

    public static RelationshipMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Relationship relationship, ProtocolMarshaller protocolMarshaller) {
        if (relationship == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)relationship.resourceTypeString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)relationship.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)relationship.resourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)relationship.relationshipName(), RELATIONSHIPNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

