/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.config.model.ReevaluateConfigRuleNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartConfigRulesEvaluationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, StartConfigRulesEvaluationRequest> {
    private final List<String> configRuleNames;

    private StartConfigRulesEvaluationRequest(BuilderImpl builder) {
        this.configRuleNames = builder.configRuleNames;
    }

    public List<String> configRuleNames() {
        return this.configRuleNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.configRuleNames() == null ? 0 : this.configRuleNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConfigRulesEvaluationRequest)) {
            return false;
        }
        StartConfigRulesEvaluationRequest other = (StartConfigRulesEvaluationRequest)((Object)obj);
        if (other.configRuleNames() == null ^ this.configRuleNames() == null) {
            return false;
        }
        return other.configRuleNames() == null || other.configRuleNames().equals(this.configRuleNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.configRuleNames() != null) {
            sb.append("ConfigRuleNames: ").append(this.configRuleNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleNames": {
                return Optional.of(clazz.cast(this.configRuleNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> configRuleNames;

        private BuilderImpl() {
        }

        private BuilderImpl(StartConfigRulesEvaluationRequest model) {
            this.configRuleNames(model.configRuleNames);
        }

        public final Collection<String> getConfigRuleNames() {
            return this.configRuleNames;
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ReevaluateConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String ... configRuleNames) {
            this.configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ReevaluateConfigRuleNamesCopier.copy(configRuleNames);
        }

        public StartConfigRulesEvaluationRequest build() {
            return new StartConfigRulesEvaluationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StartConfigRulesEvaluationRequest> {
        public Builder configRuleNames(Collection<String> var1);

        public Builder configRuleNames(String ... var1);
    }
}

