/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.config.model.Evaluation;
import software.amazon.awssdk.services.config.model.EvaluationsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutEvaluationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PutEvaluationsResponse> {
    private final List<Evaluation> failedEvaluations;

    private PutEvaluationsResponse(BuilderImpl builder) {
        this.failedEvaluations = builder.failedEvaluations;
    }

    public List<Evaluation> failedEvaluations() {
        return this.failedEvaluations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.failedEvaluations() == null ? 0 : this.failedEvaluations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEvaluationsResponse)) {
            return false;
        }
        PutEvaluationsResponse other = (PutEvaluationsResponse)((Object)obj);
        if (other.failedEvaluations() == null ^ this.failedEvaluations() == null) {
            return false;
        }
        return other.failedEvaluations() == null || other.failedEvaluations().equals(this.failedEvaluations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.failedEvaluations() != null) {
            sb.append("FailedEvaluations: ").append(this.failedEvaluations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedEvaluations": {
                return Optional.of(clazz.cast(this.failedEvaluations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Evaluation> failedEvaluations;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEvaluationsResponse model) {
            this.failedEvaluations(model.failedEvaluations);
        }

        public final Collection<Evaluation.Builder> getFailedEvaluations() {
            return this.failedEvaluations != null ? (Collection)this.failedEvaluations.stream().map(Evaluation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedEvaluations(Collection<Evaluation> failedEvaluations) {
            this.failedEvaluations = EvaluationsCopier.copy(failedEvaluations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEvaluations(Evaluation ... failedEvaluations) {
            this.failedEvaluations(Arrays.asList(failedEvaluations));
            return this;
        }

        public final void setFailedEvaluations(Collection<Evaluation.BuilderImpl> failedEvaluations) {
            this.failedEvaluations = EvaluationsCopier.copyFromBuilder(failedEvaluations);
        }

        public PutEvaluationsResponse build() {
            return new PutEvaluationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutEvaluationsResponse> {
        public Builder failedEvaluations(Collection<Evaluation> var1);

        public Builder failedEvaluations(Evaluation ... var1);
    }
}

