/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.config.model.DeliveryChannelNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDeliveryChannelStatusRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeDeliveryChannelStatusRequest> {
    private final List<String> deliveryChannelNames;

    private DescribeDeliveryChannelStatusRequest(BuilderImpl builder) {
        this.deliveryChannelNames = builder.deliveryChannelNames;
    }

    public List<String> deliveryChannelNames() {
        return this.deliveryChannelNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deliveryChannelNames() == null ? 0 : this.deliveryChannelNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryChannelStatusRequest)) {
            return false;
        }
        DescribeDeliveryChannelStatusRequest other = (DescribeDeliveryChannelStatusRequest)((Object)obj);
        if (other.deliveryChannelNames() == null ^ this.deliveryChannelNames() == null) {
            return false;
        }
        return other.deliveryChannelNames() == null || other.deliveryChannelNames().equals(this.deliveryChannelNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deliveryChannelNames() != null) {
            sb.append("DeliveryChannelNames: ").append(this.deliveryChannelNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryChannelNames": {
                return Optional.of(clazz.cast(this.deliveryChannelNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> deliveryChannelNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryChannelStatusRequest model) {
            this.deliveryChannelNames(model.deliveryChannelNames);
        }

        public final Collection<String> getDeliveryChannelNames() {
            return this.deliveryChannelNames;
        }

        @Override
        public final Builder deliveryChannelNames(Collection<String> deliveryChannelNames) {
            this.deliveryChannelNames = DeliveryChannelNameListCopier.copy(deliveryChannelNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryChannelNames(String ... deliveryChannelNames) {
            this.deliveryChannelNames(Arrays.asList(deliveryChannelNames));
            return this;
        }

        public final void setDeliveryChannelNames(Collection<String> deliveryChannelNames) {
            this.deliveryChannelNames = DeliveryChannelNameListCopier.copy(deliveryChannelNames);
        }

        public DescribeDeliveryChannelStatusRequest build() {
            return new DescribeDeliveryChannelStatusRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDeliveryChannelStatusRequest> {
        public Builder deliveryChannelNames(Collection<String> var1);

        public Builder deliveryChannelNames(String ... var1);
    }
}

