/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.config.model.ConfigurationRecorder;
import software.amazon.awssdk.services.config.model.ConfigurationRecorderListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeConfigurationRecordersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeConfigurationRecordersResponse> {
    private final List<ConfigurationRecorder> configurationRecorders;

    private DescribeConfigurationRecordersResponse(BuilderImpl builder) {
        this.configurationRecorders = builder.configurationRecorders;
    }

    public List<ConfigurationRecorder> configurationRecorders() {
        return this.configurationRecorders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.configurationRecorders() == null ? 0 : this.configurationRecorders().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecordersResponse)) {
            return false;
        }
        DescribeConfigurationRecordersResponse other = (DescribeConfigurationRecordersResponse)((Object)obj);
        if (other.configurationRecorders() == null ^ this.configurationRecorders() == null) {
            return false;
        }
        return other.configurationRecorders() == null || other.configurationRecorders().equals(this.configurationRecorders());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.configurationRecorders() != null) {
            sb.append("ConfigurationRecorders: ").append(this.configurationRecorders()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationRecorders": {
                return Optional.of(clazz.cast(this.configurationRecorders()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ConfigurationRecorder> configurationRecorders;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecordersResponse model) {
            this.configurationRecorders(model.configurationRecorders);
        }

        public final Collection<ConfigurationRecorder.Builder> getConfigurationRecorders() {
            return this.configurationRecorders != null ? (Collection)this.configurationRecorders.stream().map(ConfigurationRecorder::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationRecorders(Collection<ConfigurationRecorder> configurationRecorders) {
            this.configurationRecorders = ConfigurationRecorderListCopier.copy(configurationRecorders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorders(ConfigurationRecorder ... configurationRecorders) {
            this.configurationRecorders(Arrays.asList(configurationRecorders));
            return this;
        }

        public final void setConfigurationRecorders(Collection<ConfigurationRecorder.BuilderImpl> configurationRecorders) {
            this.configurationRecorders = ConfigurationRecorderListCopier.copyFromBuilder(configurationRecorders);
        }

        public DescribeConfigurationRecordersResponse build() {
            return new DescribeConfigurationRecordersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeConfigurationRecordersResponse> {
        public Builder configurationRecorders(Collection<ConfigurationRecorder> var1);

        public Builder configurationRecorders(ConfigurationRecorder ... var1);
    }
}

