/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceSummary;

@SdkInternalApi
public class ComplianceSummaryMarshaller {
    private static final MarshallingInfo<StructuredPojo> COMPLIANTRESOURCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompliantResourceCount").build();
    private static final MarshallingInfo<StructuredPojo> NONCOMPLIANTRESOURCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NonCompliantResourceCount").build();
    private static final MarshallingInfo<Instant> COMPLIANCESUMMARYTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceSummaryTimestamp").build();
    private static final ComplianceSummaryMarshaller instance = new ComplianceSummaryMarshaller();

    public static ComplianceSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(ComplianceSummary complianceSummary, ProtocolMarshaller protocolMarshaller) {
        if (complianceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)complianceSummary.compliantResourceCount(), COMPLIANTRESOURCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)complianceSummary.nonCompliantResourceCount(), NONCOMPLIANTRESOURCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)complianceSummary.complianceSummaryTimestamp(), COMPLIANCESUMMARYTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

