/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.config.model.DeliveryChannelNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDeliveryChannelsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeDeliveryChannelsRequest> {
    private final List<String> deliveryChannelNames;

    private DescribeDeliveryChannelsRequest(BuilderImpl builder) {
        this.deliveryChannelNames = builder.deliveryChannelNames;
    }

    public List<String> deliveryChannelNames() {
        return this.deliveryChannelNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deliveryChannelNames() == null ? 0 : this.deliveryChannelNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryChannelsRequest)) {
            return false;
        }
        DescribeDeliveryChannelsRequest other = (DescribeDeliveryChannelsRequest)((Object)obj);
        if (other.deliveryChannelNames() == null ^ this.deliveryChannelNames() == null) {
            return false;
        }
        return other.deliveryChannelNames() == null || other.deliveryChannelNames().equals(this.deliveryChannelNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deliveryChannelNames() != null) {
            sb.append("DeliveryChannelNames: ").append(this.deliveryChannelNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> deliveryChannelNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryChannelsRequest model) {
            this.setDeliveryChannelNames(model.deliveryChannelNames);
        }

        public final Collection<String> getDeliveryChannelNames() {
            return this.deliveryChannelNames;
        }

        @Override
        public final Builder deliveryChannelNames(Collection<String> deliveryChannelNames) {
            this.deliveryChannelNames = DeliveryChannelNameListCopier.copy(deliveryChannelNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryChannelNames(String ... deliveryChannelNames) {
            this.deliveryChannelNames(Arrays.asList(deliveryChannelNames));
            return this;
        }

        public final void setDeliveryChannelNames(Collection<String> deliveryChannelNames) {
            this.deliveryChannelNames = DeliveryChannelNameListCopier.copy(deliveryChannelNames);
        }

        @SafeVarargs
        public final void setDeliveryChannelNames(String ... deliveryChannelNames) {
            this.deliveryChannelNames(Arrays.asList(deliveryChannelNames));
        }

        public DescribeDeliveryChannelsRequest build() {
            return new DescribeDeliveryChannelsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDeliveryChannelsRequest> {
        public Builder deliveryChannelNames(Collection<String> var1);

        public Builder deliveryChannelNames(String ... var1);
    }
}

