/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.config.model.ComplianceByResource;
import software.amazon.awssdk.services.config.model.ComplianceByResourcesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeComplianceByResourceResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeComplianceByResourceResponse> {
    private final List<ComplianceByResource> complianceByResources;
    private final String nextToken;

    private DescribeComplianceByResourceResponse(BuilderImpl builder) {
        this.complianceByResources = builder.complianceByResources;
        this.nextToken = builder.nextToken;
    }

    public List<ComplianceByResource> complianceByResources() {
        return this.complianceByResources;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.complianceByResources() == null ? 0 : this.complianceByResources().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComplianceByResourceResponse)) {
            return false;
        }
        DescribeComplianceByResourceResponse other = (DescribeComplianceByResourceResponse)((Object)obj);
        if (other.complianceByResources() == null ^ this.complianceByResources() == null) {
            return false;
        }
        if (other.complianceByResources() != null && !other.complianceByResources().equals(this.complianceByResources())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.complianceByResources() != null) {
            sb.append("ComplianceByResources: ").append(this.complianceByResources()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ComplianceByResource> complianceByResources;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComplianceByResourceResponse model) {
            this.setComplianceByResources(model.complianceByResources);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ComplianceByResource> getComplianceByResources() {
            return this.complianceByResources;
        }

        @Override
        public final Builder complianceByResources(Collection<ComplianceByResource> complianceByResources) {
            this.complianceByResources = ComplianceByResourcesCopier.copy(complianceByResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceByResources(ComplianceByResource ... complianceByResources) {
            this.complianceByResources(Arrays.asList(complianceByResources));
            return this;
        }

        public final void setComplianceByResources(Collection<ComplianceByResource> complianceByResources) {
            this.complianceByResources = ComplianceByResourcesCopier.copy(complianceByResources);
        }

        @SafeVarargs
        public final void setComplianceByResources(ComplianceByResource ... complianceByResources) {
            this.complianceByResources(Arrays.asList(complianceByResources));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeComplianceByResourceResponse build() {
            return new DescribeComplianceByResourceResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeComplianceByResourceResponse> {
        public Builder complianceByResources(Collection<ComplianceByResource> var1);

        public Builder complianceByResources(ComplianceByResource ... var1);

        public Builder nextToken(String var1);
    }
}

