/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.RetentionConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RetentionConfigurationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<Integer> RETENTIONPERIODINDAYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetentionPeriodInDays").isBinary(false).build();
    private static final RetentionConfigurationMarshaller INSTANCE = new RetentionConfigurationMarshaller();

    private RetentionConfigurationMarshaller() {
    }

    public static RetentionConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RetentionConfiguration retentionConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)retentionConfiguration, (String)"retentionConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)retentionConfiguration.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)retentionConfiguration.retentionPeriodInDays(), RETENTIONPERIODINDAYS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

