/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRetentionConfigurationRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, PutRetentionConfigurationRequest> {
    private final Integer retentionPeriodInDays;

    private PutRetentionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.retentionPeriodInDays = builder.retentionPeriodInDays;
    }

    public Integer retentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodInDays());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRetentionConfigurationRequest)) {
            return false;
        }
        PutRetentionConfigurationRequest other = (PutRetentionConfigurationRequest)((Object)obj);
        return Objects.equals(this.retentionPeriodInDays(), other.retentionPeriodInDays());
    }

    public String toString() {
        return ToString.builder((String)"PutRetentionConfigurationRequest").add("RetentionPeriodInDays", (Object)this.retentionPeriodInDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriodInDays()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private Integer retentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRetentionConfigurationRequest model) {
            super(model);
            this.retentionPeriodInDays(model.retentionPeriodInDays);
        }

        public final Integer getRetentionPeriodInDays() {
            return this.retentionPeriodInDays;
        }

        @Override
        public final Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            return this;
        }

        public final void setRetentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRetentionConfigurationRequest build() {
            return new PutRetentionConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    CopyableBuilder<Builder, PutRetentionConfigurationRequest> {
        public Builder retentionPeriodInDays(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

