/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.PendingAggregationRequest;
import software.amazon.awssdk.services.config.model.PendingAggregationRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePendingAggregationRequestsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribePendingAggregationRequestsResponse> {
    private final List<PendingAggregationRequest> pendingAggregationRequests;
    private final String nextToken;

    private DescribePendingAggregationRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.pendingAggregationRequests = builder.pendingAggregationRequests;
        this.nextToken = builder.nextToken;
    }

    public List<PendingAggregationRequest> pendingAggregationRequests() {
        return this.pendingAggregationRequests;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingAggregationRequests());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePendingAggregationRequestsResponse)) {
            return false;
        }
        DescribePendingAggregationRequestsResponse other = (DescribePendingAggregationRequestsResponse)((Object)obj);
        return Objects.equals(this.pendingAggregationRequests(), other.pendingAggregationRequests()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribePendingAggregationRequestsResponse").add("PendingAggregationRequests", this.pendingAggregationRequests()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PendingAggregationRequests": {
                return Optional.ofNullable(clazz.cast(this.pendingAggregationRequests()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<PendingAggregationRequest> pendingAggregationRequests = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePendingAggregationRequestsResponse model) {
            super(model);
            this.pendingAggregationRequests(model.pendingAggregationRequests);
            this.nextToken(model.nextToken);
        }

        public final Collection<PendingAggregationRequest.Builder> getPendingAggregationRequests() {
            return this.pendingAggregationRequests != null ? (Collection)this.pendingAggregationRequests.stream().map(PendingAggregationRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pendingAggregationRequests(Collection<PendingAggregationRequest> pendingAggregationRequests) {
            this.pendingAggregationRequests = PendingAggregationRequestListCopier.copy(pendingAggregationRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingAggregationRequests(PendingAggregationRequest ... pendingAggregationRequests) {
            this.pendingAggregationRequests(Arrays.asList(pendingAggregationRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingAggregationRequests(Consumer<PendingAggregationRequest.Builder> ... pendingAggregationRequests) {
            this.pendingAggregationRequests(Stream.of(pendingAggregationRequests).map(c -> (PendingAggregationRequest)((PendingAggregationRequest.Builder)PendingAggregationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPendingAggregationRequests(Collection<PendingAggregationRequest.BuilderImpl> pendingAggregationRequests) {
            this.pendingAggregationRequests = PendingAggregationRequestListCopier.copyFromBuilder(pendingAggregationRequests);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePendingAggregationRequestsResponse build() {
            return new DescribePendingAggregationRequestsResponse(this);
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    CopyableBuilder<Builder, DescribePendingAggregationRequestsResponse> {
        public Builder pendingAggregationRequests(Collection<PendingAggregationRequest> var1);

        public Builder pendingAggregationRequests(PendingAggregationRequest ... var1);

        public Builder pendingAggregationRequests(Consumer<PendingAggregationRequest.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

