/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigurationAggregator;
import software.amazon.awssdk.services.config.model.ConfigurationAggregatorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationAggregatorsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeConfigurationAggregatorsResponse> {
    private final List<ConfigurationAggregator> configurationAggregators;
    private final String nextToken;

    private DescribeConfigurationAggregatorsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationAggregators = builder.configurationAggregators;
        this.nextToken = builder.nextToken;
    }

    public List<ConfigurationAggregator> configurationAggregators() {
        return this.configurationAggregators;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationAggregators());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationAggregatorsResponse)) {
            return false;
        }
        DescribeConfigurationAggregatorsResponse other = (DescribeConfigurationAggregatorsResponse)((Object)obj);
        return Objects.equals(this.configurationAggregators(), other.configurationAggregators()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigurationAggregatorsResponse").add("ConfigurationAggregators", this.configurationAggregators()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationAggregators": {
                return Optional.ofNullable(clazz.cast(this.configurationAggregators()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationAggregator> configurationAggregators = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationAggregatorsResponse model) {
            super(model);
            this.configurationAggregators(model.configurationAggregators);
            this.nextToken(model.nextToken);
        }

        public final Collection<ConfigurationAggregator.Builder> getConfigurationAggregators() {
            return this.configurationAggregators != null ? (Collection)this.configurationAggregators.stream().map(ConfigurationAggregator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationAggregators(Collection<ConfigurationAggregator> configurationAggregators) {
            this.configurationAggregators = ConfigurationAggregatorListCopier.copy(configurationAggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationAggregators(ConfigurationAggregator ... configurationAggregators) {
            this.configurationAggregators(Arrays.asList(configurationAggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationAggregators(Consumer<ConfigurationAggregator.Builder> ... configurationAggregators) {
            this.configurationAggregators(Stream.of(configurationAggregators).map(c -> (ConfigurationAggregator)((ConfigurationAggregator.Builder)ConfigurationAggregator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationAggregators(Collection<ConfigurationAggregator.BuilderImpl> configurationAggregators) {
            this.configurationAggregators = ConfigurationAggregatorListCopier.copyFromBuilder(configurationAggregators);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConfigurationAggregatorsResponse build() {
            return new DescribeConfigurationAggregatorsResponse(this);
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    CopyableBuilder<Builder, DescribeConfigurationAggregatorsResponse> {
        public Builder configurationAggregators(Collection<ConfigurationAggregator> var1);

        public Builder configurationAggregators(ConfigurationAggregator ... var1);

        public Builder configurationAggregators(Consumer<ConfigurationAggregator.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

