/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ConfigRuleComplianceFilters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAggregateComplianceByConfigRulesRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DescribeAggregateComplianceByConfigRulesRequest> {
    private final String configurationAggregatorName;
    private final ConfigRuleComplianceFilters filters;
    private final Integer limit;
    private final String nextToken;

    private DescribeAggregateComplianceByConfigRulesRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.filters = builder.filters;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public String configurationAggregatorName() {
        return this.configurationAggregatorName;
    }

    public ConfigRuleComplianceFilters filters() {
        return this.filters;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAggregateComplianceByConfigRulesRequest)) {
            return false;
        }
        DescribeAggregateComplianceByConfigRulesRequest other = (DescribeAggregateComplianceByConfigRulesRequest)((Object)obj);
        return Objects.equals(this.configurationAggregatorName(), other.configurationAggregatorName()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAggregateComplianceByConfigRulesRequest").add("ConfigurationAggregatorName", (Object)this.configurationAggregatorName()).add("Filters", (Object)this.filters()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationAggregatorName": {
                return Optional.ofNullable(clazz.cast(this.configurationAggregatorName()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String configurationAggregatorName;
        private ConfigRuleComplianceFilters filters;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAggregateComplianceByConfigRulesRequest model) {
            super(model);
            this.configurationAggregatorName(model.configurationAggregatorName);
            this.filters(model.filters);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getConfigurationAggregatorName() {
            return this.configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        public final ConfigRuleComplianceFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(ConfigRuleComplianceFilters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(ConfigRuleComplianceFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAggregateComplianceByConfigRulesRequest build() {
            return new DescribeAggregateComplianceByConfigRulesRequest(this);
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    CopyableBuilder<Builder, DescribeAggregateComplianceByConfigRulesRequest> {
        public Builder configurationAggregatorName(String var1);

        public Builder filters(ConfigRuleComplianceFilters var1);

        default public Builder filters(Consumer<ConfigRuleComplianceFilters.Builder> filters) {
            return this.filters((ConfigRuleComplianceFilters)((ConfigRuleComplianceFilters.Builder)ConfigRuleComplianceFilters.builder().applyMutation(filters)).build());
        }

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

