/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ConfigRuleComplianceSummaryFiltersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigRuleComplianceSummaryFilters
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigRuleComplianceSummaryFilters> {
    private final String accountId;
    private final String awsRegion;

    private ConfigRuleComplianceSummaryFilters(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.awsRegion = builder.awsRegion;
    }

    public String accountId() {
        return this.accountId;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRuleComplianceSummaryFilters)) {
            return false;
        }
        ConfigRuleComplianceSummaryFilters other = (ConfigRuleComplianceSummaryFilters)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.awsRegion(), other.awsRegion());
    }

    public String toString() {
        return ToString.builder((String)"ConfigRuleComplianceSummaryFilters").add("AccountId", (Object)this.accountId()).add("AwsRegion", (Object)this.awsRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigRuleComplianceSummaryFiltersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String awsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigRuleComplianceSummaryFilters model) {
            this.accountId(model.accountId);
            this.awsRegion(model.awsRegion);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public ConfigRuleComplianceSummaryFilters build() {
            return new ConfigRuleComplianceSummaryFilters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigRuleComplianceSummaryFilters> {
        public Builder accountId(String var1);

        public Builder awsRegion(String var1);
    }
}

