/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.DeliveryStatus;
import software.amazon.awssdk.services.config.transform.ConfigExportDeliveryInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigExportDeliveryInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigExportDeliveryInfo> {
    private final String lastStatus;
    private final String lastErrorCode;
    private final String lastErrorMessage;
    private final Instant lastAttemptTime;
    private final Instant lastSuccessfulTime;
    private final Instant nextDeliveryTime;

    private ConfigExportDeliveryInfo(BuilderImpl builder) {
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastAttemptTime = builder.lastAttemptTime;
        this.lastSuccessfulTime = builder.lastSuccessfulTime;
        this.nextDeliveryTime = builder.nextDeliveryTime;
    }

    public DeliveryStatus lastStatus() {
        return DeliveryStatus.fromValue(this.lastStatus);
    }

    public String lastStatusAsString() {
        return this.lastStatus;
    }

    public String lastErrorCode() {
        return this.lastErrorCode;
    }

    public String lastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Instant lastAttemptTime() {
        return this.lastAttemptTime;
    }

    public Instant lastSuccessfulTime() {
        return this.lastSuccessfulTime;
    }

    public Instant nextDeliveryTime() {
        return this.nextDeliveryTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAttemptTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextDeliveryTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigExportDeliveryInfo)) {
            return false;
        }
        ConfigExportDeliveryInfo other = (ConfigExportDeliveryInfo)obj;
        return Objects.equals(this.lastStatusAsString(), other.lastStatusAsString()) && Objects.equals(this.lastErrorCode(), other.lastErrorCode()) && Objects.equals(this.lastErrorMessage(), other.lastErrorMessage()) && Objects.equals(this.lastAttemptTime(), other.lastAttemptTime()) && Objects.equals(this.lastSuccessfulTime(), other.lastSuccessfulTime()) && Objects.equals(this.nextDeliveryTime(), other.nextDeliveryTime());
    }

    public String toString() {
        return ToString.builder((String)"ConfigExportDeliveryInfo").add("LastStatus", (Object)this.lastStatusAsString()).add("LastErrorCode", (Object)this.lastErrorCode()).add("LastErrorMessage", (Object)this.lastErrorMessage()).add("LastAttemptTime", (Object)this.lastAttemptTime()).add("LastSuccessfulTime", (Object)this.lastSuccessfulTime()).add("NextDeliveryTime", (Object)this.nextDeliveryTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lastStatus": {
                return Optional.ofNullable(clazz.cast(this.lastStatusAsString()));
            }
            case "lastErrorCode": {
                return Optional.ofNullable(clazz.cast(this.lastErrorCode()));
            }
            case "lastErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.lastErrorMessage()));
            }
            case "lastAttemptTime": {
                return Optional.ofNullable(clazz.cast(this.lastAttemptTime()));
            }
            case "lastSuccessfulTime": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulTime()));
            }
            case "nextDeliveryTime": {
                return Optional.ofNullable(clazz.cast(this.nextDeliveryTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigExportDeliveryInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String lastStatus;
        private String lastErrorCode;
        private String lastErrorMessage;
        private Instant lastAttemptTime;
        private Instant lastSuccessfulTime;
        private Instant nextDeliveryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigExportDeliveryInfo model) {
            this.lastStatus(model.lastStatus);
            this.lastErrorCode(model.lastErrorCode);
            this.lastErrorMessage(model.lastErrorMessage);
            this.lastAttemptTime(model.lastAttemptTime);
            this.lastSuccessfulTime(model.lastSuccessfulTime);
            this.nextDeliveryTime(model.nextDeliveryTime);
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(DeliveryStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final String getLastErrorCode() {
            return this.lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return this.lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Instant getLastAttemptTime() {
            return this.lastAttemptTime;
        }

        @Override
        public final Builder lastAttemptTime(Instant lastAttemptTime) {
            this.lastAttemptTime = lastAttemptTime;
            return this;
        }

        public final void setLastAttemptTime(Instant lastAttemptTime) {
            this.lastAttemptTime = lastAttemptTime;
        }

        public final Instant getLastSuccessfulTime() {
            return this.lastSuccessfulTime;
        }

        @Override
        public final Builder lastSuccessfulTime(Instant lastSuccessfulTime) {
            this.lastSuccessfulTime = lastSuccessfulTime;
            return this;
        }

        public final void setLastSuccessfulTime(Instant lastSuccessfulTime) {
            this.lastSuccessfulTime = lastSuccessfulTime;
        }

        public final Instant getNextDeliveryTime() {
            return this.nextDeliveryTime;
        }

        @Override
        public final Builder nextDeliveryTime(Instant nextDeliveryTime) {
            this.nextDeliveryTime = nextDeliveryTime;
            return this;
        }

        public final void setNextDeliveryTime(Instant nextDeliveryTime) {
            this.nextDeliveryTime = nextDeliveryTime;
        }

        public ConfigExportDeliveryInfo build() {
            return new ConfigExportDeliveryInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigExportDeliveryInfo> {
        public Builder lastStatus(String var1);

        public Builder lastStatus(DeliveryStatus var1);

        public Builder lastErrorCode(String var1);

        public Builder lastErrorMessage(String var1);

        public Builder lastAttemptTime(Instant var1);

        public Builder lastSuccessfulTime(Instant var1);

        public Builder nextDeliveryTime(Instant var1);
    }
}

