/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.Compliance;
import software.amazon.awssdk.services.config.transform.AggregateComplianceByConfigRuleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregateComplianceByConfigRule
implements StructuredPojo,
ToCopyableBuilder<Builder, AggregateComplianceByConfigRule> {
    private final String configRuleName;
    private final Compliance compliance;
    private final String accountId;
    private final String awsRegion;

    private AggregateComplianceByConfigRule(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.compliance = builder.compliance;
        this.accountId = builder.accountId;
        this.awsRegion = builder.awsRegion;
    }

    public String configRuleName() {
        return this.configRuleName;
    }

    public Compliance compliance() {
        return this.compliance;
    }

    public String accountId() {
        return this.accountId;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.compliance());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateComplianceByConfigRule)) {
            return false;
        }
        AggregateComplianceByConfigRule other = (AggregateComplianceByConfigRule)obj;
        return Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.compliance(), other.compliance()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.awsRegion(), other.awsRegion());
    }

    public String toString() {
        return ToString.builder((String)"AggregateComplianceByConfigRule").add("ConfigRuleName", (Object)this.configRuleName()).add("Compliance", (Object)this.compliance()).add("AccountId", (Object)this.accountId()).add("AwsRegion", (Object)this.awsRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "Compliance": {
                return Optional.ofNullable(clazz.cast(this.compliance()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AggregateComplianceByConfigRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private Compliance compliance;
        private String accountId;
        private String awsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateComplianceByConfigRule model) {
            this.configRuleName(model.configRuleName);
            this.compliance(model.compliance);
            this.accountId(model.accountId);
            this.awsRegion(model.awsRegion);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final Compliance.Builder getCompliance() {
            return this.compliance != null ? this.compliance.toBuilder() : null;
        }

        @Override
        public final Builder compliance(Compliance compliance) {
            this.compliance = compliance;
            return this;
        }

        public final void setCompliance(Compliance.BuilderImpl compliance) {
            this.compliance = compliance != null ? compliance.build() : null;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public AggregateComplianceByConfigRule build() {
            return new AggregateComplianceByConfigRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AggregateComplianceByConfigRule> {
        public Builder configRuleName(String var1);

        public Builder compliance(Compliance var1);

        default public Builder compliance(Consumer<Compliance.Builder> compliance) {
            return this.compliance((Compliance)((Compliance.Builder)Compliance.builder().applyMutation(compliance)).build());
        }

        public Builder accountId(String var1);

        public Builder awsRegion(String var1);
    }
}

