/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.Scope;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ScopeMarshaller {
    private static final MarshallingInfo<List> COMPLIANCERESOURCETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceResourceTypes").isBinary(false).build();
    private static final MarshallingInfo<String> TAGKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagKey").isBinary(false).build();
    private static final MarshallingInfo<String> TAGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagValue").isBinary(false).build();
    private static final MarshallingInfo<String> COMPLIANCERESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceResourceId").isBinary(false).build();
    private static final ScopeMarshaller INSTANCE = new ScopeMarshaller();

    private ScopeMarshaller() {
    }

    public static ScopeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Scope scope, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)scope, (String)"scope");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(scope.complianceResourceTypes(), COMPLIANCERESOURCETYPES_BINDING);
            protocolMarshaller.marshall((Object)scope.tagKey(), TAGKEY_BINDING);
            protocolMarshaller.marshall((Object)scope.tagValue(), TAGVALUE_BINDING);
            protocolMarshaller.marshall((Object)scope.complianceResourceId(), COMPLIANCERESOURCEID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

