/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.RecordingGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RecordingGroupMarshaller {
    private static final MarshallingInfo<Boolean> ALLSUPPORTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allSupported").isBinary(false).build();
    private static final MarshallingInfo<Boolean> INCLUDEGLOBALRESOURCETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("includeGlobalResourceTypes").isBinary(false).build();
    private static final MarshallingInfo<List> RESOURCETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceTypes").isBinary(false).build();
    private static final RecordingGroupMarshaller INSTANCE = new RecordingGroupMarshaller();

    private RecordingGroupMarshaller() {
    }

    public static RecordingGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RecordingGroup recordingGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)recordingGroup, (String)"recordingGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)recordingGroup.allSupported(), ALLSUPPORTED_BINDING);
            protocolMarshaller.marshall((Object)recordingGroup.includeGlobalResourceTypes(), INCLUDEGLOBALRESOURCETYPES_BINDING);
            protocolMarshaller.marshall(recordingGroup.resourceTypesAsStrings(), RESOURCETYPES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

