/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ConfigRuleNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigRuleEvaluationStatusRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DescribeConfigRuleEvaluationStatusRequest> {
    private final List<String> configRuleNames;
    private final String nextToken;
    private final Integer limit;

    private DescribeConfigRuleEvaluationStatusRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleNames = builder.configRuleNames;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public List<String> configRuleNames() {
        return this.configRuleNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigRuleEvaluationStatusRequest)) {
            return false;
        }
        DescribeConfigRuleEvaluationStatusRequest other = (DescribeConfigRuleEvaluationStatusRequest)((Object)obj);
        return Objects.equals(this.configRuleNames(), other.configRuleNames()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigRuleEvaluationStatusRequest").add("ConfigRuleNames", this.configRuleNames()).add("NextToken", (Object)this.nextToken()).add("Limit", (Object)this.limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleNames": {
                return Optional.ofNullable(clazz.cast(this.configRuleNames()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private List<String> configRuleNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigRuleEvaluationStatusRequest model) {
            super(model);
            this.configRuleNames(model.configRuleNames);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
        }

        public final Collection<String> getConfigRuleNames() {
            return this.configRuleNames;
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String ... configRuleNames) {
            this.configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigRuleEvaluationStatusRequest build() {
            return new DescribeConfigRuleEvaluationStatusRequest(this);
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    CopyableBuilder<Builder, DescribeConfigRuleEvaluationStatusRequest> {
        public Builder configRuleNames(Collection<String> var1);

        public Builder configRuleNames(String ... var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

