/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.util.Date;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.ConfigurationItem;

@SdkInternalApi
public class ConfigurationItemMarshaller {
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").build();
    private static final MarshallingInfo<Date> CONFIGURATIONITEMCAPTURETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationItemCaptureTime").build();
    private static final MarshallingInfo<String> CONFIGURATIONITEMSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationItemStatus").build();
    private static final MarshallingInfo<String> CONFIGURATIONSTATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationStateId").build();
    private static final MarshallingInfo<String> CONFIGURATIONITEMMD5HASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationItemMD5Hash").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceId").build();
    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceName").build();
    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsRegion").build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").build();
    private static final MarshallingInfo<Date> RESOURCECREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceCreationTime").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<List> RELATEDEVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relatedEvents").build();
    private static final MarshallingInfo<List> RELATIONSHIPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relationships").build();
    private static final MarshallingInfo<String> CONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configuration").build();
    private static final MarshallingInfo<Map> SUPPLEMENTARYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supplementaryConfiguration").build();
    private static final ConfigurationItemMarshaller instance = new ConfigurationItemMarshaller();

    public static ConfigurationItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConfigurationItem configurationItem, ProtocolMarshaller protocolMarshaller) {
        if (configurationItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)configurationItem.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.configurationItemCaptureTime(), CONFIGURATIONITEMCAPTURETIME_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.configurationItemStatus(), CONFIGURATIONITEMSTATUS_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.configurationStateId(), CONFIGURATIONSTATEID_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.configurationItemMD5Hash(), CONFIGURATIONITEMMD5HASH_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.resourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.resourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.awsRegion(), AWSREGION_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.resourceCreationTime(), RESOURCECREATIONTIME_BINDING);
            protocolMarshaller.marshall(configurationItem.tags(), TAGS_BINDING);
            protocolMarshaller.marshall(configurationItem.relatedEvents(), RELATEDEVENTS_BINDING);
            protocolMarshaller.marshall(configurationItem.relationships(), RELATIONSHIPS_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.configuration(), CONFIGURATION_BINDING);
            protocolMarshaller.marshall(configurationItem.supplementaryConfiguration(), SUPPLEMENTARYCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

