/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.config.model.EvaluationResult;
import software.amazon.awssdk.services.config.model.EvaluationResultsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetComplianceDetailsByResourceResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetComplianceDetailsByResourceResponse> {
    private final List<EvaluationResult> evaluationResults;
    private final String nextToken;

    private GetComplianceDetailsByResourceResponse(BuilderImpl builder) {
        this.evaluationResults = builder.evaluationResults;
        this.nextToken = builder.nextToken;
    }

    public List<EvaluationResult> evaluationResults() {
        return this.evaluationResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.evaluationResults() == null ? 0 : this.evaluationResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceDetailsByResourceResponse)) {
            return false;
        }
        GetComplianceDetailsByResourceResponse other = (GetComplianceDetailsByResourceResponse)((Object)obj);
        if (other.evaluationResults() == null ^ this.evaluationResults() == null) {
            return false;
        }
        if (other.evaluationResults() != null && !other.evaluationResults().equals(this.evaluationResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.evaluationResults() != null) {
            sb.append("EvaluationResults: ").append(this.evaluationResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<EvaluationResult> evaluationResults = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceDetailsByResourceResponse model) {
            this.setEvaluationResults(model.evaluationResults);
            this.setNextToken(model.nextToken);
        }

        public final Collection<EvaluationResult> getEvaluationResults() {
            return this.evaluationResults;
        }

        @Override
        public final Builder evaluationResults(Collection<EvaluationResult> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copy(evaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(EvaluationResult ... evaluationResults) {
            if (this.evaluationResults == null) {
                this.evaluationResults = new SdkInternalList(evaluationResults.length);
            }
            for (EvaluationResult e : evaluationResults) {
                this.evaluationResults.add(e);
            }
            return this;
        }

        public final void setEvaluationResults(Collection<EvaluationResult> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copy(evaluationResults);
        }

        @SafeVarargs
        public final void setEvaluationResults(EvaluationResult ... evaluationResults) {
            if (this.evaluationResults == null) {
                this.evaluationResults = new SdkInternalList(evaluationResults.length);
            }
            for (EvaluationResult e : evaluationResults) {
                this.evaluationResults.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetComplianceDetailsByResourceResponse build() {
            return new GetComplianceDetailsByResourceResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetComplianceDetailsByResourceResponse> {
        public Builder evaluationResults(Collection<EvaluationResult> var1);

        public Builder evaluationResults(EvaluationResult ... var1);

        public Builder nextToken(String var1);
    }
}

