/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.model.ComplianceTypesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeComplianceByResourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeComplianceByResourceRequest> {
    private final String resourceType;
    private final String resourceId;
    private final List<String> complianceTypes;
    private final Integer limit;
    private final String nextToken;

    private DescribeComplianceByResourceRequest(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.complianceTypes = builder.complianceTypes;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public List<String> complianceTypes() {
        return this.complianceTypes;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.complianceTypes() == null ? 0 : this.complianceTypes().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComplianceByResourceRequest)) {
            return false;
        }
        DescribeComplianceByResourceRequest other = (DescribeComplianceByResourceRequest)((Object)obj);
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.complianceTypes() == null ^ this.complianceTypes() == null) {
            return false;
        }
        if (other.complianceTypes() != null && !other.complianceTypes().equals(this.complianceTypes())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.complianceTypes() != null) {
            sb.append("ComplianceTypes: ").append(this.complianceTypes()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String resourceId;
        private List<String> complianceTypes = new SdkInternalList();
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComplianceByResourceRequest model) {
            this.setResourceType(model.resourceType);
            this.setResourceId(model.resourceId);
            this.setComplianceTypes(model.complianceTypes);
            this.setLimit(model.limit);
            this.setNextToken(model.nextToken);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<String> getComplianceTypes() {
            return this.complianceTypes;
        }

        @Override
        public final Builder complianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(String ... complianceTypes) {
            if (this.complianceTypes == null) {
                this.complianceTypes = new SdkInternalList(complianceTypes.length);
            }
            for (String e : complianceTypes) {
                this.complianceTypes.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(ComplianceType ... complianceTypes) {
            if (this.complianceTypes == null) {
                this.complianceTypes = new SdkInternalList(complianceTypes.length);
            }
            for (ComplianceType ele : complianceTypes) {
                this.complianceTypes.add(ele.toString());
            }
            return this;
        }

        public final void setComplianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
        }

        @SafeVarargs
        public final void setComplianceTypes(String ... complianceTypes) {
            if (this.complianceTypes == null) {
                this.complianceTypes = new SdkInternalList(complianceTypes.length);
            }
            for (String e : complianceTypes) {
                this.complianceTypes.add(e);
            }
        }

        @SafeVarargs
        public final void setComplianceTypes(ComplianceType ... complianceTypes) {
            if (this.complianceTypes == null) {
                this.complianceTypes = new SdkInternalList(complianceTypes.length);
            }
            for (ComplianceType ele : complianceTypes) {
                this.complianceTypes.add(ele.toString());
            }
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeComplianceByResourceRequest build() {
            return new DescribeComplianceByResourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeComplianceByResourceRequest> {
        public Builder resourceType(String var1);

        public Builder resourceId(String var1);

        public Builder complianceTypes(Collection<String> var1);

        public Builder complianceTypes(String ... var1);

        public Builder complianceTypes(ComplianceType ... var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);
    }
}

