/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.config.model.ConfigurationItemStatus;
import software.amazon.awssdk.services.config.model.RelatedEventListCopier;
import software.amazon.awssdk.services.config.model.Relationship;
import software.amazon.awssdk.services.config.model.RelationshipListCopier;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.services.config.model.SupplementaryConfigurationCopier;
import software.amazon.awssdk.services.config.model.TagsCopier;
import software.amazon.awssdk.services.config.transform.ConfigurationItemMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigurationItem
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigurationItem> {
    private final String version;
    private final String accountId;
    private final Date configurationItemCaptureTime;
    private final String configurationItemStatus;
    private final String configurationStateId;
    private final String configurationItemMD5Hash;
    private final String arn;
    private final String resourceType;
    private final String resourceId;
    private final String resourceName;
    private final String awsRegion;
    private final String availabilityZone;
    private final Date resourceCreationTime;
    private final Map<String, String> tags;
    private final List<String> relatedEvents;
    private final List<Relationship> relationships;
    private final String configuration;
    private final Map<String, String> supplementaryConfiguration;

    private ConfigurationItem(BuilderImpl builder) {
        this.version = builder.version;
        this.accountId = builder.accountId;
        this.configurationItemCaptureTime = builder.configurationItemCaptureTime;
        this.configurationItemStatus = builder.configurationItemStatus;
        this.configurationStateId = builder.configurationStateId;
        this.configurationItemMD5Hash = builder.configurationItemMD5Hash;
        this.arn = builder.arn;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.awsRegion = builder.awsRegion;
        this.availabilityZone = builder.availabilityZone;
        this.resourceCreationTime = builder.resourceCreationTime;
        this.tags = builder.tags;
        this.relatedEvents = builder.relatedEvents;
        this.relationships = builder.relationships;
        this.configuration = builder.configuration;
        this.supplementaryConfiguration = builder.supplementaryConfiguration;
    }

    public String version() {
        return this.version;
    }

    public String accountId() {
        return this.accountId;
    }

    public Date configurationItemCaptureTime() {
        return this.configurationItemCaptureTime;
    }

    public String configurationItemStatus() {
        return this.configurationItemStatus;
    }

    public String configurationStateId() {
        return this.configurationStateId;
    }

    public String configurationItemMD5Hash() {
        return this.configurationItemMD5Hash;
    }

    public String arn() {
        return this.arn;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Date resourceCreationTime() {
        return this.resourceCreationTime;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public List<String> relatedEvents() {
        return this.relatedEvents;
    }

    public List<Relationship> relationships() {
        return this.relationships;
    }

    public String configuration() {
        return this.configuration;
    }

    public Map<String, String> supplementaryConfiguration() {
        return this.supplementaryConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.configurationItemCaptureTime() == null ? 0 : this.configurationItemCaptureTime().hashCode());
        hashCode = 31 * hashCode + (this.configurationItemStatus() == null ? 0 : this.configurationItemStatus().hashCode());
        hashCode = 31 * hashCode + (this.configurationStateId() == null ? 0 : this.configurationStateId().hashCode());
        hashCode = 31 * hashCode + (this.configurationItemMD5Hash() == null ? 0 : this.configurationItemMD5Hash().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.resourceName() == null ? 0 : this.resourceName().hashCode());
        hashCode = 31 * hashCode + (this.awsRegion() == null ? 0 : this.awsRegion().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.resourceCreationTime() == null ? 0 : this.resourceCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.relatedEvents() == null ? 0 : this.relatedEvents().hashCode());
        hashCode = 31 * hashCode + (this.relationships() == null ? 0 : this.relationships().hashCode());
        hashCode = 31 * hashCode + (this.configuration() == null ? 0 : this.configuration().hashCode());
        hashCode = 31 * hashCode + (this.supplementaryConfiguration() == null ? 0 : this.supplementaryConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationItem)) {
            return false;
        }
        ConfigurationItem other = (ConfigurationItem)obj;
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.configurationItemCaptureTime() == null ^ this.configurationItemCaptureTime() == null) {
            return false;
        }
        if (other.configurationItemCaptureTime() != null && !other.configurationItemCaptureTime().equals(this.configurationItemCaptureTime())) {
            return false;
        }
        if (other.configurationItemStatus() == null ^ this.configurationItemStatus() == null) {
            return false;
        }
        if (other.configurationItemStatus() != null && !other.configurationItemStatus().equals(this.configurationItemStatus())) {
            return false;
        }
        if (other.configurationStateId() == null ^ this.configurationStateId() == null) {
            return false;
        }
        if (other.configurationStateId() != null && !other.configurationStateId().equals(this.configurationStateId())) {
            return false;
        }
        if (other.configurationItemMD5Hash() == null ^ this.configurationItemMD5Hash() == null) {
            return false;
        }
        if (other.configurationItemMD5Hash() != null && !other.configurationItemMD5Hash().equals(this.configurationItemMD5Hash())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.resourceName() == null ^ this.resourceName() == null) {
            return false;
        }
        if (other.resourceName() != null && !other.resourceName().equals(this.resourceName())) {
            return false;
        }
        if (other.awsRegion() == null ^ this.awsRegion() == null) {
            return false;
        }
        if (other.awsRegion() != null && !other.awsRegion().equals(this.awsRegion())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.resourceCreationTime() == null ^ this.resourceCreationTime() == null) {
            return false;
        }
        if (other.resourceCreationTime() != null && !other.resourceCreationTime().equals(this.resourceCreationTime())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.relatedEvents() == null ^ this.relatedEvents() == null) {
            return false;
        }
        if (other.relatedEvents() != null && !other.relatedEvents().equals(this.relatedEvents())) {
            return false;
        }
        if (other.relationships() == null ^ this.relationships() == null) {
            return false;
        }
        if (other.relationships() != null && !other.relationships().equals(this.relationships())) {
            return false;
        }
        if (other.configuration() == null ^ this.configuration() == null) {
            return false;
        }
        if (other.configuration() != null && !other.configuration().equals(this.configuration())) {
            return false;
        }
        if (other.supplementaryConfiguration() == null ^ this.supplementaryConfiguration() == null) {
            return false;
        }
        return other.supplementaryConfiguration() == null || other.supplementaryConfiguration().equals(this.supplementaryConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.configurationItemCaptureTime() != null) {
            sb.append("ConfigurationItemCaptureTime: ").append(this.configurationItemCaptureTime()).append(",");
        }
        if (this.configurationItemStatus() != null) {
            sb.append("ConfigurationItemStatus: ").append(this.configurationItemStatus()).append(",");
        }
        if (this.configurationStateId() != null) {
            sb.append("ConfigurationStateId: ").append(this.configurationStateId()).append(",");
        }
        if (this.configurationItemMD5Hash() != null) {
            sb.append("ConfigurationItemMD5Hash: ").append(this.configurationItemMD5Hash()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.resourceName() != null) {
            sb.append("ResourceName: ").append(this.resourceName()).append(",");
        }
        if (this.awsRegion() != null) {
            sb.append("AwsRegion: ").append(this.awsRegion()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.resourceCreationTime() != null) {
            sb.append("ResourceCreationTime: ").append(this.resourceCreationTime()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.relatedEvents() != null) {
            sb.append("RelatedEvents: ").append(this.relatedEvents()).append(",");
        }
        if (this.relationships() != null) {
            sb.append("Relationships: ").append(this.relationships()).append(",");
        }
        if (this.configuration() != null) {
            sb.append("Configuration: ").append(this.configuration()).append(",");
        }
        if (this.supplementaryConfiguration() != null) {
            sb.append("SupplementaryConfiguration: ").append(this.supplementaryConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String version;
        private String accountId;
        private Date configurationItemCaptureTime;
        private String configurationItemStatus;
        private String configurationStateId;
        private String configurationItemMD5Hash;
        private String arn;
        private String resourceType;
        private String resourceId;
        private String resourceName;
        private String awsRegion;
        private String availabilityZone;
        private Date resourceCreationTime;
        private Map<String, String> tags;
        private List<String> relatedEvents = new SdkInternalList();
        private List<Relationship> relationships = new SdkInternalList();
        private String configuration;
        private Map<String, String> supplementaryConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationItem model) {
            this.setVersion(model.version);
            this.setAccountId(model.accountId);
            this.setConfigurationItemCaptureTime(model.configurationItemCaptureTime);
            this.setConfigurationItemStatus(model.configurationItemStatus);
            this.setConfigurationStateId(model.configurationStateId);
            this.setConfigurationItemMD5Hash(model.configurationItemMD5Hash);
            this.setArn(model.arn);
            this.setResourceType(model.resourceType);
            this.setResourceId(model.resourceId);
            this.setResourceName(model.resourceName);
            this.setAwsRegion(model.awsRegion);
            this.setAvailabilityZone(model.availabilityZone);
            this.setResourceCreationTime(model.resourceCreationTime);
            this.setTags(model.tags);
            this.setRelatedEvents(model.relatedEvents);
            this.setRelationships(model.relationships);
            this.setConfiguration(model.configuration);
            this.setSupplementaryConfiguration(model.supplementaryConfiguration);
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Date getConfigurationItemCaptureTime() {
            return this.configurationItemCaptureTime;
        }

        @Override
        public final Builder configurationItemCaptureTime(Date configurationItemCaptureTime) {
            this.configurationItemCaptureTime = StandardMemberCopier.copy((Date)configurationItemCaptureTime);
            return this;
        }

        public final void setConfigurationItemCaptureTime(Date configurationItemCaptureTime) {
            this.configurationItemCaptureTime = StandardMemberCopier.copy((Date)configurationItemCaptureTime);
        }

        public final String getConfigurationItemStatus() {
            return this.configurationItemStatus;
        }

        @Override
        public final Builder configurationItemStatus(String configurationItemStatus) {
            this.configurationItemStatus = configurationItemStatus;
            return this;
        }

        @Override
        public final Builder configurationItemStatus(ConfigurationItemStatus configurationItemStatus) {
            this.configurationItemStatus(configurationItemStatus.toString());
            return this;
        }

        public final void setConfigurationItemStatus(String configurationItemStatus) {
            this.configurationItemStatus = configurationItemStatus;
        }

        public final void setConfigurationItemStatus(ConfigurationItemStatus configurationItemStatus) {
            this.configurationItemStatus(configurationItemStatus.toString());
        }

        public final String getConfigurationStateId() {
            return this.configurationStateId;
        }

        @Override
        public final Builder configurationStateId(String configurationStateId) {
            this.configurationStateId = configurationStateId;
            return this;
        }

        public final void setConfigurationStateId(String configurationStateId) {
            this.configurationStateId = configurationStateId;
        }

        public final String getConfigurationItemMD5Hash() {
            return this.configurationItemMD5Hash;
        }

        @Override
        public final Builder configurationItemMD5Hash(String configurationItemMD5Hash) {
            this.configurationItemMD5Hash = configurationItemMD5Hash;
            return this;
        }

        public final void setConfigurationItemMD5Hash(String configurationItemMD5Hash) {
            this.configurationItemMD5Hash = configurationItemMD5Hash;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Date getResourceCreationTime() {
            return this.resourceCreationTime;
        }

        @Override
        public final Builder resourceCreationTime(Date resourceCreationTime) {
            this.resourceCreationTime = StandardMemberCopier.copy((Date)resourceCreationTime);
            return this;
        }

        public final void setResourceCreationTime(Date resourceCreationTime) {
            this.resourceCreationTime = StandardMemberCopier.copy((Date)resourceCreationTime);
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Collection<String> getRelatedEvents() {
            return this.relatedEvents;
        }

        @Override
        public final Builder relatedEvents(Collection<String> relatedEvents) {
            this.relatedEvents = RelatedEventListCopier.copy(relatedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedEvents(String ... relatedEvents) {
            if (this.relatedEvents == null) {
                this.relatedEvents = new SdkInternalList(relatedEvents.length);
            }
            for (String e : relatedEvents) {
                this.relatedEvents.add(e);
            }
            return this;
        }

        public final void setRelatedEvents(Collection<String> relatedEvents) {
            this.relatedEvents = RelatedEventListCopier.copy(relatedEvents);
        }

        @SafeVarargs
        public final void setRelatedEvents(String ... relatedEvents) {
            if (this.relatedEvents == null) {
                this.relatedEvents = new SdkInternalList(relatedEvents.length);
            }
            for (String e : relatedEvents) {
                this.relatedEvents.add(e);
            }
        }

        public final Collection<Relationship> getRelationships() {
            return this.relationships;
        }

        @Override
        public final Builder relationships(Collection<Relationship> relationships) {
            this.relationships = RelationshipListCopier.copy(relationships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationships(Relationship ... relationships) {
            if (this.relationships == null) {
                this.relationships = new SdkInternalList(relationships.length);
            }
            for (Relationship e : relationships) {
                this.relationships.add(e);
            }
            return this;
        }

        public final void setRelationships(Collection<Relationship> relationships) {
            this.relationships = RelationshipListCopier.copy(relationships);
        }

        @SafeVarargs
        public final void setRelationships(Relationship ... relationships) {
            if (this.relationships == null) {
                this.relationships = new SdkInternalList(relationships.length);
            }
            for (Relationship e : relationships) {
                this.relationships.add(e);
            }
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        public final Map<String, String> getSupplementaryConfiguration() {
            return this.supplementaryConfiguration;
        }

        @Override
        public final Builder supplementaryConfiguration(Map<String, String> supplementaryConfiguration) {
            this.supplementaryConfiguration = SupplementaryConfigurationCopier.copy(supplementaryConfiguration);
            return this;
        }

        public final void setSupplementaryConfiguration(Map<String, String> supplementaryConfiguration) {
            this.supplementaryConfiguration = SupplementaryConfigurationCopier.copy(supplementaryConfiguration);
        }

        public ConfigurationItem build() {
            return new ConfigurationItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigurationItem> {
        public Builder version(String var1);

        public Builder accountId(String var1);

        public Builder configurationItemCaptureTime(Date var1);

        public Builder configurationItemStatus(String var1);

        public Builder configurationItemStatus(ConfigurationItemStatus var1);

        public Builder configurationStateId(String var1);

        public Builder configurationItemMD5Hash(String var1);

        public Builder arn(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceId(String var1);

        public Builder resourceName(String var1);

        public Builder awsRegion(String var1);

        public Builder availabilityZone(String var1);

        public Builder resourceCreationTime(Date var1);

        public Builder tags(Map<String, String> var1);

        public Builder relatedEvents(Collection<String> var1);

        public Builder relatedEvents(String ... var1);

        public Builder relationships(Collection<Relationship> var1);

        public Builder relationships(Relationship ... var1);

        public Builder configuration(String var1);

        public Builder supplementaryConfiguration(Map<String, String> var1);
    }
}

