/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.config.model.ComplianceContributorCount;
import software.amazon.awssdk.services.config.transform.ComplianceSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComplianceSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, ComplianceSummary> {
    private final ComplianceContributorCount compliantResourceCount;
    private final ComplianceContributorCount nonCompliantResourceCount;
    private final Date complianceSummaryTimestamp;

    private ComplianceSummary(BuilderImpl builder) {
        this.compliantResourceCount = builder.compliantResourceCount;
        this.nonCompliantResourceCount = builder.nonCompliantResourceCount;
        this.complianceSummaryTimestamp = builder.complianceSummaryTimestamp;
    }

    public ComplianceContributorCount compliantResourceCount() {
        return this.compliantResourceCount;
    }

    public ComplianceContributorCount nonCompliantResourceCount() {
        return this.nonCompliantResourceCount;
    }

    public Date complianceSummaryTimestamp() {
        return this.complianceSummaryTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.compliantResourceCount() == null ? 0 : this.compliantResourceCount().hashCode());
        hashCode = 31 * hashCode + (this.nonCompliantResourceCount() == null ? 0 : this.nonCompliantResourceCount().hashCode());
        hashCode = 31 * hashCode + (this.complianceSummaryTimestamp() == null ? 0 : this.complianceSummaryTimestamp().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceSummary)) {
            return false;
        }
        ComplianceSummary other = (ComplianceSummary)obj;
        if (other.compliantResourceCount() == null ^ this.compliantResourceCount() == null) {
            return false;
        }
        if (other.compliantResourceCount() != null && !other.compliantResourceCount().equals(this.compliantResourceCount())) {
            return false;
        }
        if (other.nonCompliantResourceCount() == null ^ this.nonCompliantResourceCount() == null) {
            return false;
        }
        if (other.nonCompliantResourceCount() != null && !other.nonCompliantResourceCount().equals(this.nonCompliantResourceCount())) {
            return false;
        }
        if (other.complianceSummaryTimestamp() == null ^ this.complianceSummaryTimestamp() == null) {
            return false;
        }
        return other.complianceSummaryTimestamp() == null || other.complianceSummaryTimestamp().equals(this.complianceSummaryTimestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.compliantResourceCount() != null) {
            sb.append("CompliantResourceCount: ").append(this.compliantResourceCount()).append(",");
        }
        if (this.nonCompliantResourceCount() != null) {
            sb.append("NonCompliantResourceCount: ").append(this.nonCompliantResourceCount()).append(",");
        }
        if (this.complianceSummaryTimestamp() != null) {
            sb.append("ComplianceSummaryTimestamp: ").append(this.complianceSummaryTimestamp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private ComplianceContributorCount compliantResourceCount;
        private ComplianceContributorCount nonCompliantResourceCount;
        private Date complianceSummaryTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceSummary model) {
            this.setCompliantResourceCount(model.compliantResourceCount);
            this.setNonCompliantResourceCount(model.nonCompliantResourceCount);
            this.setComplianceSummaryTimestamp(model.complianceSummaryTimestamp);
        }

        public final ComplianceContributorCount getCompliantResourceCount() {
            return this.compliantResourceCount;
        }

        @Override
        public final Builder compliantResourceCount(ComplianceContributorCount compliantResourceCount) {
            this.compliantResourceCount = compliantResourceCount;
            return this;
        }

        public final void setCompliantResourceCount(ComplianceContributorCount compliantResourceCount) {
            this.compliantResourceCount = compliantResourceCount;
        }

        public final ComplianceContributorCount getNonCompliantResourceCount() {
            return this.nonCompliantResourceCount;
        }

        @Override
        public final Builder nonCompliantResourceCount(ComplianceContributorCount nonCompliantResourceCount) {
            this.nonCompliantResourceCount = nonCompliantResourceCount;
            return this;
        }

        public final void setNonCompliantResourceCount(ComplianceContributorCount nonCompliantResourceCount) {
            this.nonCompliantResourceCount = nonCompliantResourceCount;
        }

        public final Date getComplianceSummaryTimestamp() {
            return this.complianceSummaryTimestamp;
        }

        @Override
        public final Builder complianceSummaryTimestamp(Date complianceSummaryTimestamp) {
            this.complianceSummaryTimestamp = StandardMemberCopier.copy((Date)complianceSummaryTimestamp);
            return this;
        }

        public final void setComplianceSummaryTimestamp(Date complianceSummaryTimestamp) {
            this.complianceSummaryTimestamp = StandardMemberCopier.copy((Date)complianceSummaryTimestamp);
        }

        public ComplianceSummary build() {
            return new ComplianceSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComplianceSummary> {
        public Builder compliantResourceCount(ComplianceContributorCount var1);

        public Builder nonCompliantResourceCount(ComplianceContributorCount var1);

        public Builder complianceSummaryTimestamp(Date var1);
    }
}

