/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComparisonOperator {
    STRING_EQUALS("StringEquals"),
    STRING_NOT_EQUALS("StringNotEquals"),
    STRING_EQUALS_IGNORE_CASE("StringEqualsIgnoreCase"),
    STRING_NOT_EQUALS_IGNORE_CASE("StringNotEqualsIgnoreCase"),
    STRING_LIKE("StringLike"),
    STRING_NOT_LIKE("StringNotLike"),
    NUMERIC_EQUALS("NumericEquals"),
    NUMERIC_NOT_EQUALS("NumericNotEquals"),
    NUMERIC_LESS_THAN("NumericLessThan"),
    NUMERIC_LESS_THAN_EQUALS("NumericLessThanEquals"),
    NUMERIC_GREATER_THAN("NumericGreaterThan"),
    NUMERIC_GREATER_THAN_EQUALS("NumericGreaterThanEquals"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComparisonOperator> VALUE_MAP;
    private final String value;

    private ComparisonOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComparisonOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComparisonOperator> knownValues() {
        EnumSet<ComparisonOperator> knownValues = EnumSet.allOf(ComparisonOperator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComparisonOperator.class, ComparisonOperator::toString);
    }
}

