/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationRulePreviewSummariesRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationRulePreviewSummariesResponse;
import software.amazon.awssdk.services.computeoptimizerautomation.model.PreviewResultSummary;

public class ListAutomationRulePreviewSummariesIterable
implements SdkIterable<ListAutomationRulePreviewSummariesResponse> {
    private final ComputeOptimizerAutomationClient client;
    private final ListAutomationRulePreviewSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAutomationRulePreviewSummariesIterable(ComputeOptimizerAutomationClient client, ListAutomationRulePreviewSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAutomationRulePreviewSummariesResponseFetcher();
    }

    public Iterator<ListAutomationRulePreviewSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PreviewResultSummary> previewResultSummaries() {
        Function<ListAutomationRulePreviewSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.previewResultSummaries() != null) {
                return response.previewResultSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAutomationRulePreviewSummariesResponseFetcher
    implements SyncPageFetcher<ListAutomationRulePreviewSummariesResponse> {
        private ListAutomationRulePreviewSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomationRulePreviewSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAutomationRulePreviewSummariesResponse nextPage(ListAutomationRulePreviewSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListAutomationRulePreviewSummariesIterable.this.client.listAutomationRulePreviewSummaries(ListAutomationRulePreviewSummariesIterable.this.firstRequest);
            }
            return ListAutomationRulePreviewSummariesIterable.this.client.listAutomationRulePreviewSummaries((ListAutomationRulePreviewSummariesRequest)((Object)ListAutomationRulePreviewSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

