/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationEventSummary;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationEventSummaryListCopier;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ComputeOptimizerAutomationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAutomationEventSummariesResponse
extends ComputeOptimizerAutomationResponse
implements ToCopyableBuilder<Builder, ListAutomationEventSummariesResponse> {
    private static final SdkField<List<AutomationEventSummary>> AUTOMATION_EVENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("automationEventSummaries").getter(ListAutomationEventSummariesResponse.getter(ListAutomationEventSummariesResponse::automationEventSummaries)).setter(ListAutomationEventSummariesResponse.setter(Builder::automationEventSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automationEventSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationEventSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAutomationEventSummariesResponse.getter(ListAutomationEventSummariesResponse::nextToken)).setter(ListAutomationEventSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EVENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAutomationEventSummariesResponse.memberNameToFieldInitializer();
    private final List<AutomationEventSummary> automationEventSummaries;
    private final String nextToken;

    private ListAutomationEventSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.automationEventSummaries = builder.automationEventSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAutomationEventSummaries() {
        return this.automationEventSummaries != null && !(this.automationEventSummaries instanceof SdkAutoConstructList);
    }

    public final List<AutomationEventSummary> automationEventSummaries() {
        return this.automationEventSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutomationEventSummaries() ? this.automationEventSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomationEventSummariesResponse)) {
            return false;
        }
        ListAutomationEventSummariesResponse other = (ListAutomationEventSummariesResponse)((Object)obj);
        return this.hasAutomationEventSummaries() == other.hasAutomationEventSummaries() && Objects.equals(this.automationEventSummaries(), other.automationEventSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAutomationEventSummariesResponse").add("AutomationEventSummaries", this.hasAutomationEventSummaries() ? this.automationEventSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "automationEventSummaries": {
                return Optional.ofNullable(clazz.cast(this.automationEventSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("automationEventSummaries", AUTOMATION_EVENT_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutomationEventSummariesResponse, T> g) {
        return obj -> g.apply((ListAutomationEventSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerAutomationResponse.BuilderImpl
    implements Builder {
        private List<AutomationEventSummary> automationEventSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomationEventSummariesResponse model) {
            super(model);
            this.automationEventSummaries(model.automationEventSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AutomationEventSummary.Builder> getAutomationEventSummaries() {
            List<AutomationEventSummary.Builder> result = AutomationEventSummaryListCopier.copyToBuilder(this.automationEventSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutomationEventSummaries(Collection<AutomationEventSummary.BuilderImpl> automationEventSummaries) {
            this.automationEventSummaries = AutomationEventSummaryListCopier.copyFromBuilder(automationEventSummaries);
        }

        @Override
        public final Builder automationEventSummaries(Collection<AutomationEventSummary> automationEventSummaries) {
            this.automationEventSummaries = AutomationEventSummaryListCopier.copy(automationEventSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationEventSummaries(AutomationEventSummary ... automationEventSummaries) {
            this.automationEventSummaries(Arrays.asList(automationEventSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationEventSummaries(Consumer<AutomationEventSummary.Builder> ... automationEventSummaries) {
            this.automationEventSummaries(Stream.of(automationEventSummaries).map(c -> (AutomationEventSummary)((AutomationEventSummary.Builder)AutomationEventSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAutomationEventSummariesResponse build() {
            return new ListAutomationEventSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerAutomationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAutomationEventSummariesResponse> {
        public Builder automationEventSummaries(Collection<AutomationEventSummary> var1);

        public Builder automationEventSummaries(AutomationEventSummary ... var1);

        public Builder automationEventSummaries(Consumer<AutomationEventSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

