/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizerautomation.model.OrganizationConfigurationAccountIdsCopier;
import software.amazon.awssdk.services.computeoptimizerautomation.model.RuleApplyOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationConfiguration> {
    private static final SdkField<String> RULE_APPLY_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleApplyOrder").getter(OrganizationConfiguration.getter(OrganizationConfiguration::ruleApplyOrderAsString)).setter(OrganizationConfiguration.setter(Builder::ruleApplyOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleApplyOrder").build()}).build();
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIds").getter(OrganizationConfiguration.getter(OrganizationConfiguration::accountIds)).setter(OrganizationConfiguration.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_APPLY_ORDER_FIELD, ACCOUNT_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrganizationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ruleApplyOrder;
    private final List<String> accountIds;

    private OrganizationConfiguration(BuilderImpl builder) {
        this.ruleApplyOrder = builder.ruleApplyOrder;
        this.accountIds = builder.accountIds;
    }

    public final RuleApplyOrder ruleApplyOrder() {
        return RuleApplyOrder.fromValue(this.ruleApplyOrder);
    }

    public final String ruleApplyOrderAsString() {
        return this.ruleApplyOrder;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleApplyOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationConfiguration)) {
            return false;
        }
        OrganizationConfiguration other = (OrganizationConfiguration)obj;
        return Objects.equals(this.ruleApplyOrderAsString(), other.ruleApplyOrderAsString()) && this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationConfiguration").add("RuleApplyOrder", (Object)this.ruleApplyOrderAsString()).add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleApplyOrder": {
                return Optional.ofNullable(clazz.cast(this.ruleApplyOrderAsString()));
            }
            case "accountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleApplyOrder", RULE_APPLY_ORDER_FIELD);
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrganizationConfiguration, T> g) {
        return obj -> g.apply((OrganizationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleApplyOrder;
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationConfiguration model) {
            this.ruleApplyOrder(model.ruleApplyOrder);
            this.accountIds(model.accountIds);
        }

        public final String getRuleApplyOrder() {
            return this.ruleApplyOrder;
        }

        public final void setRuleApplyOrder(String ruleApplyOrder) {
            this.ruleApplyOrder = ruleApplyOrder;
        }

        @Override
        public final Builder ruleApplyOrder(String ruleApplyOrder) {
            this.ruleApplyOrder = ruleApplyOrder;
            return this;
        }

        @Override
        public final Builder ruleApplyOrder(RuleApplyOrder ruleApplyOrder) {
            this.ruleApplyOrder(ruleApplyOrder == null ? null : ruleApplyOrder.toString());
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = OrganizationConfigurationAccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = OrganizationConfigurationAccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public OrganizationConfiguration build() {
            return new OrganizationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationConfiguration> {
        public Builder ruleApplyOrder(String var1);

        public Builder ruleApplyOrder(RuleApplyOrder var1);

        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);
    }
}

