/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationEvent;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationEventsCopier;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ComputeOptimizerAutomationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAutomationEventsResponse
extends ComputeOptimizerAutomationResponse
implements ToCopyableBuilder<Builder, ListAutomationEventsResponse> {
    private static final SdkField<List<AutomationEvent>> AUTOMATION_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("automationEvents").getter(ListAutomationEventsResponse.getter(ListAutomationEventsResponse::automationEvents)).setter(ListAutomationEventsResponse.setter(Builder::automationEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automationEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAutomationEventsResponse.getter(ListAutomationEventsResponse::nextToken)).setter(ListAutomationEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EVENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAutomationEventsResponse.memberNameToFieldInitializer();
    private final List<AutomationEvent> automationEvents;
    private final String nextToken;

    private ListAutomationEventsResponse(BuilderImpl builder) {
        super(builder);
        this.automationEvents = builder.automationEvents;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAutomationEvents() {
        return this.automationEvents != null && !(this.automationEvents instanceof SdkAutoConstructList);
    }

    public final List<AutomationEvent> automationEvents() {
        return this.automationEvents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutomationEvents() ? this.automationEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomationEventsResponse)) {
            return false;
        }
        ListAutomationEventsResponse other = (ListAutomationEventsResponse)((Object)obj);
        return this.hasAutomationEvents() == other.hasAutomationEvents() && Objects.equals(this.automationEvents(), other.automationEvents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAutomationEventsResponse").add("AutomationEvents", this.hasAutomationEvents() ? this.automationEvents() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "automationEvents": {
                return Optional.ofNullable(clazz.cast(this.automationEvents()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("automationEvents", AUTOMATION_EVENTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutomationEventsResponse, T> g) {
        return obj -> g.apply((ListAutomationEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerAutomationResponse.BuilderImpl
    implements Builder {
        private List<AutomationEvent> automationEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomationEventsResponse model) {
            super(model);
            this.automationEvents(model.automationEvents);
            this.nextToken(model.nextToken);
        }

        public final List<AutomationEvent.Builder> getAutomationEvents() {
            List<AutomationEvent.Builder> result = AutomationEventsCopier.copyToBuilder(this.automationEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutomationEvents(Collection<AutomationEvent.BuilderImpl> automationEvents) {
            this.automationEvents = AutomationEventsCopier.copyFromBuilder(automationEvents);
        }

        @Override
        public final Builder automationEvents(Collection<AutomationEvent> automationEvents) {
            this.automationEvents = AutomationEventsCopier.copy(automationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationEvents(AutomationEvent ... automationEvents) {
            this.automationEvents(Arrays.asList(automationEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationEvents(Consumer<AutomationEvent.Builder> ... automationEvents) {
            this.automationEvents(Stream.of(automationEvents).map(c -> (AutomationEvent)((AutomationEvent.Builder)AutomationEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAutomationEventsResponse build() {
            return new ListAutomationEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerAutomationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAutomationEventsResponse> {
        public Builder automationEvents(Collection<AutomationEvent> var1);

        public Builder automationEvents(AutomationEvent ... var1);

        public Builder automationEvents(Consumer<AutomationEvent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

