/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationAsyncClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationEventSummary;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationEventSummariesRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationEventSummariesResponse;

public class ListAutomationEventSummariesPublisher
implements SdkPublisher<ListAutomationEventSummariesResponse> {
    private final ComputeOptimizerAutomationAsyncClient client;
    private final ListAutomationEventSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAutomationEventSummariesPublisher(ComputeOptimizerAutomationAsyncClient client, ListAutomationEventSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAutomationEventSummariesPublisher(ComputeOptimizerAutomationAsyncClient client, ListAutomationEventSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAutomationEventSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAutomationEventSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutomationEventSummary> automationEventSummaries() {
        Function<ListAutomationEventSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.automationEventSummaries() != null) {
                return response.automationEventSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAutomationEventSummariesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAutomationEventSummariesResponseFetcher
    implements AsyncPageFetcher<ListAutomationEventSummariesResponse> {
        private ListAutomationEventSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomationEventSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAutomationEventSummariesResponse> nextPage(ListAutomationEventSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListAutomationEventSummariesPublisher.this.client.listAutomationEventSummaries(ListAutomationEventSummariesPublisher.this.firstRequest);
            }
            return ListAutomationEventSummariesPublisher.this.client.listAutomationEventSummaries((ListAutomationEventSummariesRequest)((Object)ListAutomationEventSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

