/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ComputeOptimizerAutomationResponse;
import software.amazon.awssdk.services.computeoptimizerautomation.model.RecommendedAction;
import software.amazon.awssdk.services.computeoptimizerautomation.model.RecommendedActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecommendedActionsResponse
extends ComputeOptimizerAutomationResponse
implements ToCopyableBuilder<Builder, ListRecommendedActionsResponse> {
    private static final SdkField<List<RecommendedAction>> RECOMMENDED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendedActions").getter(ListRecommendedActionsResponse.getter(ListRecommendedActionsResponse::recommendedActions)).setter(ListRecommendedActionsResponse.setter(Builder::recommendedActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendedAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRecommendedActionsResponse.getter(ListRecommendedActionsResponse::nextToken)).setter(ListRecommendedActionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDED_ACTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRecommendedActionsResponse.memberNameToFieldInitializer();
    private final List<RecommendedAction> recommendedActions;
    private final String nextToken;

    private ListRecommendedActionsResponse(BuilderImpl builder) {
        super(builder);
        this.recommendedActions = builder.recommendedActions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRecommendedActions() {
        return this.recommendedActions != null && !(this.recommendedActions instanceof SdkAutoConstructList);
    }

    public final List<RecommendedAction> recommendedActions() {
        return this.recommendedActions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendedActions() ? this.recommendedActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendedActionsResponse)) {
            return false;
        }
        ListRecommendedActionsResponse other = (ListRecommendedActionsResponse)((Object)obj);
        return this.hasRecommendedActions() == other.hasRecommendedActions() && Objects.equals(this.recommendedActions(), other.recommendedActions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecommendedActionsResponse").add("RecommendedActions", this.hasRecommendedActions() ? this.recommendedActions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recommendedActions": {
                return Optional.ofNullable(clazz.cast(this.recommendedActions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recommendedActions", RECOMMENDED_ACTIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendedActionsResponse, T> g) {
        return obj -> g.apply((ListRecommendedActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerAutomationResponse.BuilderImpl
    implements Builder {
        private List<RecommendedAction> recommendedActions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendedActionsResponse model) {
            super(model);
            this.recommendedActions(model.recommendedActions);
            this.nextToken(model.nextToken);
        }

        public final List<RecommendedAction.Builder> getRecommendedActions() {
            List<RecommendedAction.Builder> result = RecommendedActionsCopier.copyToBuilder(this.recommendedActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendedActions(Collection<RecommendedAction.BuilderImpl> recommendedActions) {
            this.recommendedActions = RecommendedActionsCopier.copyFromBuilder(recommendedActions);
        }

        @Override
        public final Builder recommendedActions(Collection<RecommendedAction> recommendedActions) {
            this.recommendedActions = RecommendedActionsCopier.copy(recommendedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActions(RecommendedAction ... recommendedActions) {
            this.recommendedActions(Arrays.asList(recommendedActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActions(Consumer<RecommendedAction.Builder> ... recommendedActions) {
            this.recommendedActions(Stream.of(recommendedActions).map(c -> (RecommendedAction)((RecommendedAction.Builder)RecommendedAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRecommendedActionsResponse build() {
            return new ListRecommendedActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerAutomationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecommendedActionsResponse> {
        public Builder recommendedActions(Collection<RecommendedAction> var1);

        public Builder recommendedActions(RecommendedAction ... var1);

        public Builder recommendedActions(Consumer<RecommendedAction.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

