/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory utilization
 * headroom.
 * </p>
 * <note>
 * <p>
 * This preference is only available for the Amazon EC2 instance resource type.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UtilizationPreference implements SdkPojo, Serializable,
        ToCopyableBuilder<UtilizationPreference.Builder, UtilizationPreference> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricName").getter(getter(UtilizationPreference::metricNameAsString))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<CustomizableMetricParameters> METRIC_PARAMETERS_FIELD = SdkField
            .<CustomizableMetricParameters> builder(MarshallingType.SDK_POJO).memberName("metricParameters")
            .getter(getter(UtilizationPreference::metricParameters)).setter(setter(Builder::metricParameters))
            .constructor(CustomizableMetricParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricParameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            METRIC_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final CustomizableMetricParameters metricParameters;

    private UtilizationPreference(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.metricParameters = builder.metricParameters;
    }

    /**
     * <p>
     * The name of the resource utilization metric name to customize.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link CustomizableMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metricNameAsString}.
     * </p>
     * 
     * @return The name of the resource utilization metric name to customize.
     * @see CustomizableMetricName
     */
    public final CustomizableMetricName metricName() {
        return CustomizableMetricName.fromValue(metricName);
    }

    /**
     * <p>
     * The name of the resource utilization metric name to customize.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link CustomizableMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metricNameAsString}.
     * </p>
     * 
     * @return The name of the resource utilization metric name to customize.
     * @see CustomizableMetricName
     */
    public final String metricNameAsString() {
        return metricName;
    }

    /**
     * <p>
     * The parameters to set when customizing the resource utilization thresholds.
     * </p>
     * 
     * @return The parameters to set when customizing the resource utilization thresholds.
     */
    public final CustomizableMetricParameters metricParameters() {
        return metricParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtilizationPreference)) {
            return false;
        }
        UtilizationPreference other = (UtilizationPreference) obj;
        return Objects.equals(metricNameAsString(), other.metricNameAsString())
                && Objects.equals(metricParameters(), other.metricParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UtilizationPreference").add("MetricName", metricNameAsString())
                .add("MetricParameters", metricParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricNameAsString()));
        case "metricParameters":
            return Optional.ofNullable(clazz.cast(metricParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("metricParameters", METRIC_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UtilizationPreference, T> g) {
        return obj -> g.apply((UtilizationPreference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UtilizationPreference> {
        /**
         * <p>
         * The name of the resource utilization metric name to customize.
         * </p>
         * 
         * @param metricName
         *        The name of the resource utilization metric name to customize.
         * @see CustomizableMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizableMetricName
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The name of the resource utilization metric name to customize.
         * </p>
         * 
         * @param metricName
         *        The name of the resource utilization metric name to customize.
         * @see CustomizableMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizableMetricName
         */
        Builder metricName(CustomizableMetricName metricName);

        /**
         * <p>
         * The parameters to set when customizing the resource utilization thresholds.
         * </p>
         * 
         * @param metricParameters
         *        The parameters to set when customizing the resource utilization thresholds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricParameters(CustomizableMetricParameters metricParameters);

        /**
         * <p>
         * The parameters to set when customizing the resource utilization thresholds.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomizableMetricParameters.Builder}
         * avoiding the need to create one manually via {@link CustomizableMetricParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomizableMetricParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #metricParameters(CustomizableMetricParameters)}.
         * 
         * @param metricParameters
         *        a consumer that will call methods on {@link CustomizableMetricParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricParameters(CustomizableMetricParameters)
         */
        default Builder metricParameters(Consumer<CustomizableMetricParameters.Builder> metricParameters) {
            return metricParameters(CustomizableMetricParameters.builder().applyMutation(metricParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private CustomizableMetricParameters metricParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UtilizationPreference model) {
            metricName(model.metricName);
            metricParameters(model.metricParameters);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(CustomizableMetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final CustomizableMetricParameters.Builder getMetricParameters() {
            return metricParameters != null ? metricParameters.toBuilder() : null;
        }

        public final void setMetricParameters(CustomizableMetricParameters.BuilderImpl metricParameters) {
            this.metricParameters = metricParameters != null ? metricParameters.build() : null;
        }

        @Override
        public final Builder metricParameters(CustomizableMetricParameters metricParameters) {
            this.metricParameters = metricParameters;
            return this;
        }

        @Override
        public UtilizationPreference build() {
            return new UtilizationPreference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
