/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the recommendation options for a DB instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RDSDBInstanceRecommendationOption implements SdkPojo, Serializable,
        ToCopyableBuilder<RDSDBInstanceRecommendationOption.Builder, RDSDBInstanceRecommendationOption> {
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbInstanceClass").getter(getter(RDSDBInstanceRecommendationOption::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbInstanceClass").build()).build();

    private static final SdkField<List<RDSDBUtilizationMetric>> PROJECTED_UTILIZATION_METRICS_FIELD = SdkField
            .<List<RDSDBUtilizationMetric>> builder(MarshallingType.LIST)
            .memberName("projectedUtilizationMetrics")
            .getter(getter(RDSDBInstanceRecommendationOption::projectedUtilizationMetrics))
            .setter(setter(Builder::projectedUtilizationMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectedUtilizationMetrics")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RDSDBUtilizationMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(RDSDBUtilizationMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> PERFORMANCE_RISK_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("performanceRisk").getter(getter(RDSDBInstanceRecommendationOption::performanceRisk))
            .setter(setter(Builder::performanceRisk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performanceRisk").build()).build();

    private static final SdkField<Integer> RANK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("rank")
            .getter(getter(RDSDBInstanceRecommendationOption::rank)).setter(setter(Builder::rank))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()).build();

    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField
            .<SavingsOpportunity> builder(MarshallingType.SDK_POJO).memberName("savingsOpportunity")
            .getter(getter(RDSDBInstanceRecommendationOption::savingsOpportunity)).setter(setter(Builder::savingsOpportunity))
            .constructor(SavingsOpportunity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build())
            .build();

    private static final SdkField<RDSInstanceSavingsOpportunityAfterDiscounts> SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD = SdkField
            .<RDSInstanceSavingsOpportunityAfterDiscounts> builder(MarshallingType.SDK_POJO)
            .memberName("savingsOpportunityAfterDiscounts")
            .getter(getter(RDSDBInstanceRecommendationOption::savingsOpportunityAfterDiscounts))
            .setter(setter(Builder::savingsOpportunityAfterDiscounts))
            .constructor(RDSInstanceSavingsOpportunityAfterDiscounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityAfterDiscounts")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_CLASS_FIELD,
            PROJECTED_UTILIZATION_METRICS_FIELD, PERFORMANCE_RISK_FIELD, RANK_FIELD, SAVINGS_OPPORTUNITY_FIELD,
            SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dbInstanceClass;

    private final List<RDSDBUtilizationMetric> projectedUtilizationMetrics;

    private final Double performanceRisk;

    private final Integer rank;

    private final SavingsOpportunity savingsOpportunity;

    private final RDSInstanceSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

    private RDSDBInstanceRecommendationOption(BuilderImpl builder) {
        this.dbInstanceClass = builder.dbInstanceClass;
        this.projectedUtilizationMetrics = builder.projectedUtilizationMetrics;
        this.performanceRisk = builder.performanceRisk;
        this.rank = builder.rank;
        this.savingsOpportunity = builder.savingsOpportunity;
        this.savingsOpportunityAfterDiscounts = builder.savingsOpportunityAfterDiscounts;
    }

    /**
     * <p>
     * Describes the DB instance class recommendation option for your Amazon Aurora or RDS database.
     * </p>
     * 
     * @return Describes the DB instance class recommendation option for your Amazon Aurora or RDS database.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProjectedUtilizationMetrics property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProjectedUtilizationMetrics() {
        return projectedUtilizationMetrics != null && !(projectedUtilizationMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the projected utilization metrics of the DB instance recommendation option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProjectedUtilizationMetrics} method.
     * </p>
     * 
     * @return An array of objects that describe the projected utilization metrics of the DB instance recommendation
     *         option.
     */
    public final List<RDSDBUtilizationMetric> projectedUtilizationMetrics() {
        return projectedUtilizationMetrics;
    }

    /**
     * <p>
     * The performance risk of the DB instance recommendation option.
     * </p>
     * 
     * @return The performance risk of the DB instance recommendation option.
     */
    public final Double performanceRisk() {
        return performanceRisk;
    }

    /**
     * <p>
     * The rank identifier of the DB instance recommendation option.
     * </p>
     * 
     * @return The rank identifier of the DB instance recommendation option.
     */
    public final Integer rank() {
        return rank;
    }

    /**
     * Returns the value of the SavingsOpportunity property for this object.
     * 
     * @return The value of the SavingsOpportunity property for this object.
     */
    public final SavingsOpportunity savingsOpportunity() {
        return savingsOpportunity;
    }

    /**
     * <p>
     * Describes the savings opportunity for Amazon Aurora and RDS database recommendations or for the recommendation
     * option.
     * </p>
     * <p>
     * Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can
     * achieve this by implementing a given Compute Optimizer recommendation.
     * </p>
     * 
     * @return Describes the savings opportunity for Amazon Aurora and RDS database recommendations or for the
     *         recommendation option. </p>
     *         <p>
     *         Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You
     *         can achieve this by implementing a given Compute Optimizer recommendation.
     */
    public final RDSInstanceSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts() {
        return savingsOpportunityAfterDiscounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(hasProjectedUtilizationMetrics() ? projectedUtilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(performanceRisk());
        hashCode = 31 * hashCode + Objects.hashCode(rank());
        hashCode = 31 * hashCode + Objects.hashCode(savingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(savingsOpportunityAfterDiscounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDBInstanceRecommendationOption)) {
            return false;
        }
        RDSDBInstanceRecommendationOption other = (RDSDBInstanceRecommendationOption) obj;
        return Objects.equals(dbInstanceClass(), other.dbInstanceClass())
                && hasProjectedUtilizationMetrics() == other.hasProjectedUtilizationMetrics()
                && Objects.equals(projectedUtilizationMetrics(), other.projectedUtilizationMetrics())
                && Objects.equals(performanceRisk(), other.performanceRisk()) && Objects.equals(rank(), other.rank())
                && Objects.equals(savingsOpportunity(), other.savingsOpportunity())
                && Objects.equals(savingsOpportunityAfterDiscounts(), other.savingsOpportunityAfterDiscounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RDSDBInstanceRecommendationOption").add("DbInstanceClass", dbInstanceClass())
                .add("ProjectedUtilizationMetrics", hasProjectedUtilizationMetrics() ? projectedUtilizationMetrics() : null)
                .add("PerformanceRisk", performanceRisk()).add("Rank", rank()).add("SavingsOpportunity", savingsOpportunity())
                .add("SavingsOpportunityAfterDiscounts", savingsOpportunityAfterDiscounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dbInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "projectedUtilizationMetrics":
            return Optional.ofNullable(clazz.cast(projectedUtilizationMetrics()));
        case "performanceRisk":
            return Optional.ofNullable(clazz.cast(performanceRisk()));
        case "rank":
            return Optional.ofNullable(clazz.cast(rank()));
        case "savingsOpportunity":
            return Optional.ofNullable(clazz.cast(savingsOpportunity()));
        case "savingsOpportunityAfterDiscounts":
            return Optional.ofNullable(clazz.cast(savingsOpportunityAfterDiscounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dbInstanceClass", DB_INSTANCE_CLASS_FIELD);
        map.put("projectedUtilizationMetrics", PROJECTED_UTILIZATION_METRICS_FIELD);
        map.put("performanceRisk", PERFORMANCE_RISK_FIELD);
        map.put("rank", RANK_FIELD);
        map.put("savingsOpportunity", SAVINGS_OPPORTUNITY_FIELD);
        map.put("savingsOpportunityAfterDiscounts", SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RDSDBInstanceRecommendationOption, T> g) {
        return obj -> g.apply((RDSDBInstanceRecommendationOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RDSDBInstanceRecommendationOption> {
        /**
         * <p>
         * Describes the DB instance class recommendation option for your Amazon Aurora or RDS database.
         * </p>
         * 
         * @param dbInstanceClass
         *        Describes the DB instance class recommendation option for your Amazon Aurora or RDS database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * An array of objects that describe the projected utilization metrics of the DB instance recommendation option.
         * </p>
         * 
         * @param projectedUtilizationMetrics
         *        An array of objects that describe the projected utilization metrics of the DB instance recommendation
         *        option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedUtilizationMetrics(Collection<RDSDBUtilizationMetric> projectedUtilizationMetrics);

        /**
         * <p>
         * An array of objects that describe the projected utilization metrics of the DB instance recommendation option.
         * </p>
         * 
         * @param projectedUtilizationMetrics
         *        An array of objects that describe the projected utilization metrics of the DB instance recommendation
         *        option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedUtilizationMetrics(RDSDBUtilizationMetric... projectedUtilizationMetrics);

        /**
         * <p>
         * An array of objects that describe the projected utilization metrics of the DB instance recommendation option.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.RDSDBUtilizationMetric.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.RDSDBUtilizationMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.RDSDBUtilizationMetric.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #projectedUtilizationMetrics(List<RDSDBUtilizationMetric>)}.
         * 
         * @param projectedUtilizationMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.RDSDBUtilizationMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectedUtilizationMetrics(java.util.Collection<RDSDBUtilizationMetric>)
         */
        Builder projectedUtilizationMetrics(Consumer<RDSDBUtilizationMetric.Builder>... projectedUtilizationMetrics);

        /**
         * <p>
         * The performance risk of the DB instance recommendation option.
         * </p>
         * 
         * @param performanceRisk
         *        The performance risk of the DB instance recommendation option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceRisk(Double performanceRisk);

        /**
         * <p>
         * The rank identifier of the DB instance recommendation option.
         * </p>
         * 
         * @param rank
         *        The rank identifier of the DB instance recommendation option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rank(Integer rank);

        /**
         * Sets the value of the SavingsOpportunity property for this object.
         *
         * @param savingsOpportunity
         *        The new value for the SavingsOpportunity property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsOpportunity(SavingsOpportunity savingsOpportunity);

        /**
         * Sets the value of the SavingsOpportunity property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SavingsOpportunity.Builder} avoiding the
         * need to create one manually via {@link SavingsOpportunity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsOpportunity.Builder#build()} is called immediately and its
         * result is passed to {@link #savingsOpportunity(SavingsOpportunity)}.
         * 
         * @param savingsOpportunity
         *        a consumer that will call methods on {@link SavingsOpportunity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsOpportunity(SavingsOpportunity)
         */
        default Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return savingsOpportunity(SavingsOpportunity.builder().applyMutation(savingsOpportunity).build());
        }

        /**
         * <p>
         * Describes the savings opportunity for Amazon Aurora and RDS database recommendations or for the
         * recommendation option.
         * </p>
         * <p>
         * Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can
         * achieve this by implementing a given Compute Optimizer recommendation.
         * </p>
         * 
         * @param savingsOpportunityAfterDiscounts
         *        Describes the savings opportunity for Amazon Aurora and RDS database recommendations or for the
         *        recommendation option. </p>
         *        <p>
         *        Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts.
         *        You can achieve this by implementing a given Compute Optimizer recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsOpportunityAfterDiscounts(RDSInstanceSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts);

        /**
         * <p>
         * Describes the savings opportunity for Amazon Aurora and RDS database recommendations or for the
         * recommendation option.
         * </p>
         * <p>
         * Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can
         * achieve this by implementing a given Compute Optimizer recommendation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RDSInstanceSavingsOpportunityAfterDiscounts.Builder} avoiding the need to create one manually via
         * {@link RDSInstanceSavingsOpportunityAfterDiscounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RDSInstanceSavingsOpportunityAfterDiscounts.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #savingsOpportunityAfterDiscounts(RDSInstanceSavingsOpportunityAfterDiscounts)}.
         * 
         * @param savingsOpportunityAfterDiscounts
         *        a consumer that will call methods on {@link RDSInstanceSavingsOpportunityAfterDiscounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsOpportunityAfterDiscounts(RDSInstanceSavingsOpportunityAfterDiscounts)
         */
        default Builder savingsOpportunityAfterDiscounts(
                Consumer<RDSInstanceSavingsOpportunityAfterDiscounts.Builder> savingsOpportunityAfterDiscounts) {
            return savingsOpportunityAfterDiscounts(RDSInstanceSavingsOpportunityAfterDiscounts.builder()
                    .applyMutation(savingsOpportunityAfterDiscounts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String dbInstanceClass;

        private List<RDSDBUtilizationMetric> projectedUtilizationMetrics = DefaultSdkAutoConstructList.getInstance();

        private Double performanceRisk;

        private Integer rank;

        private SavingsOpportunity savingsOpportunity;

        private RDSInstanceSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDBInstanceRecommendationOption model) {
            dbInstanceClass(model.dbInstanceClass);
            projectedUtilizationMetrics(model.projectedUtilizationMetrics);
            performanceRisk(model.performanceRisk);
            rank(model.rank);
            savingsOpportunity(model.savingsOpportunity);
            savingsOpportunityAfterDiscounts(model.savingsOpportunityAfterDiscounts);
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final List<RDSDBUtilizationMetric.Builder> getProjectedUtilizationMetrics() {
            List<RDSDBUtilizationMetric.Builder> result = RDSDBProjectedUtilizationMetricsCopier
                    .copyToBuilder(this.projectedUtilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectedUtilizationMetrics(
                Collection<RDSDBUtilizationMetric.BuilderImpl> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = RDSDBProjectedUtilizationMetricsCopier
                    .copyFromBuilder(projectedUtilizationMetrics);
        }

        @Override
        public final Builder projectedUtilizationMetrics(Collection<RDSDBUtilizationMetric> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = RDSDBProjectedUtilizationMetricsCopier.copy(projectedUtilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(RDSDBUtilizationMetric... projectedUtilizationMetrics) {
            projectedUtilizationMetrics(Arrays.asList(projectedUtilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(Consumer<RDSDBUtilizationMetric.Builder>... projectedUtilizationMetrics) {
            projectedUtilizationMetrics(Stream.of(projectedUtilizationMetrics)
                    .map(c -> RDSDBUtilizationMetric.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getPerformanceRisk() {
            return performanceRisk;
        }

        public final void setPerformanceRisk(Double performanceRisk) {
            this.performanceRisk = performanceRisk;
        }

        @Override
        public final Builder performanceRisk(Double performanceRisk) {
            this.performanceRisk = performanceRisk;
            return this;
        }

        public final Integer getRank() {
            return rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return savingsOpportunity != null ? savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public final RDSInstanceSavingsOpportunityAfterDiscounts.Builder getSavingsOpportunityAfterDiscounts() {
            return savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts.toBuilder() : null;
        }

        public final void setSavingsOpportunityAfterDiscounts(
                RDSInstanceSavingsOpportunityAfterDiscounts.BuilderImpl savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts
                    .build() : null;
        }

        @Override
        public final Builder savingsOpportunityAfterDiscounts(
                RDSInstanceSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts;
            return this;
        }

        @Override
        public RDSDBInstanceRecommendationOption build() {
            return new RDSDBInstanceRecommendationOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
