/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class LicenseRecommendationOptionsCopier {
    static List<LicenseRecommendationOption> copy(
            Collection<? extends LicenseRecommendationOption> licenseRecommendationOptionsParam) {
        List<LicenseRecommendationOption> list;
        if (licenseRecommendationOptionsParam == null || licenseRecommendationOptionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LicenseRecommendationOption> modifiableList = new ArrayList<>(licenseRecommendationOptionsParam.size());
            licenseRecommendationOptionsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LicenseRecommendationOption> copyFromBuilder(
            Collection<? extends LicenseRecommendationOption.Builder> licenseRecommendationOptionsParam) {
        List<LicenseRecommendationOption> list;
        if (licenseRecommendationOptionsParam == null || licenseRecommendationOptionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LicenseRecommendationOption> modifiableList = new ArrayList<>(licenseRecommendationOptionsParam.size());
            licenseRecommendationOptionsParam.forEach(entry -> {
                LicenseRecommendationOption member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LicenseRecommendationOption.Builder> copyToBuilder(
            Collection<? extends LicenseRecommendationOption> licenseRecommendationOptionsParam) {
        List<LicenseRecommendationOption.Builder> list;
        if (licenseRecommendationOptionsParam == null || licenseRecommendationOptionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LicenseRecommendationOption.Builder> modifiableList = new ArrayList<>(licenseRecommendationOptionsParam.size());
            licenseRecommendationOptionsParam.forEach(entry -> {
                LicenseRecommendationOption.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
