/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Idle resource recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdleRecommendation implements SdkPojo, Serializable,
        ToCopyableBuilder<IdleRecommendation.Builder, IdleRecommendation> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(IdleRecommendation::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(IdleRecommendation::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(IdleRecommendation::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(IdleRecommendation::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> FINDING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("finding")
            .getter(getter(IdleRecommendation::findingAsString)).setter(setter(Builder::finding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finding").build()).build();

    private static final SdkField<String> FINDING_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingDescription").getter(getter(IdleRecommendation::findingDescription))
            .setter(setter(Builder::findingDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingDescription").build())
            .build();

    private static final SdkField<IdleSavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField
            .<IdleSavingsOpportunity> builder(MarshallingType.SDK_POJO).memberName("savingsOpportunity")
            .getter(getter(IdleRecommendation::savingsOpportunity)).setter(setter(Builder::savingsOpportunity))
            .constructor(IdleSavingsOpportunity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build())
            .build();

    private static final SdkField<IdleSavingsOpportunityAfterDiscounts> SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD = SdkField
            .<IdleSavingsOpportunityAfterDiscounts> builder(MarshallingType.SDK_POJO)
            .memberName("savingsOpportunityAfterDiscounts")
            .getter(getter(IdleRecommendation::savingsOpportunityAfterDiscounts))
            .setter(setter(Builder::savingsOpportunityAfterDiscounts))
            .constructor(IdleSavingsOpportunityAfterDiscounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityAfterDiscounts")
                    .build()).build();

    private static final SdkField<List<IdleUtilizationMetric>> UTILIZATION_METRICS_FIELD = SdkField
            .<List<IdleUtilizationMetric>> builder(MarshallingType.LIST)
            .memberName("utilizationMetrics")
            .getter(getter(IdleRecommendation::utilizationMetrics))
            .setter(setter(Builder::utilizationMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdleUtilizationMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdleUtilizationMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> LOOK_BACK_PERIOD_IN_DAYS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("lookBackPeriodInDays").getter(getter(IdleRecommendation::lookBackPeriodInDays))
            .setter(setter(Builder::lookBackPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookBackPeriodInDays").build())
            .build();

    private static final SdkField<Instant> LAST_REFRESH_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastRefreshTimestamp").getter(getter(IdleRecommendation::lastRefreshTimestamp))
            .setter(setter(Builder::lastRefreshTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTimestamp").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(IdleRecommendation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, ACCOUNT_ID_FIELD, FINDING_FIELD, FINDING_DESCRIPTION_FIELD,
            SAVINGS_OPPORTUNITY_FIELD, SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD, UTILIZATION_METRICS_FIELD,
            LOOK_BACK_PERIOD_IN_DAYS_FIELD, LAST_REFRESH_TIMESTAMP_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String resourceId;

    private final String resourceType;

    private final String accountId;

    private final String finding;

    private final String findingDescription;

    private final IdleSavingsOpportunity savingsOpportunity;

    private final IdleSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

    private final List<IdleUtilizationMetric> utilizationMetrics;

    private final Double lookBackPeriodInDays;

    private final Instant lastRefreshTimestamp;

    private final List<Tag> tags;

    private IdleRecommendation(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.accountId = builder.accountId;
        this.finding = builder.finding;
        this.findingDescription = builder.findingDescription;
        this.savingsOpportunity = builder.savingsOpportunity;
        this.savingsOpportunityAfterDiscounts = builder.savingsOpportunityAfterDiscounts;
        this.utilizationMetrics = builder.utilizationMetrics;
        this.lookBackPeriodInDays = builder.lookBackPeriodInDays;
        this.lastRefreshTimestamp = builder.lastRefreshTimestamp;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the current idle resource.
     * </p>
     * 
     * @return The ARN of the current idle resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The unique identifier for the resource.
     * </p>
     * 
     * @return The unique identifier for the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of resource that is idle.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link IdleRecommendationResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource that is idle.
     * @see IdleRecommendationResourceType
     */
    public final IdleRecommendationResourceType resourceType() {
        return IdleRecommendationResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource that is idle.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link IdleRecommendationResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource that is idle.
     * @see IdleRecommendationResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the idle resource.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the idle resource.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The finding classification of an idle resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #finding} will
     * return {@link IdleFinding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #findingAsString}.
     * </p>
     * 
     * @return The finding classification of an idle resource.
     * @see IdleFinding
     */
    public final IdleFinding finding() {
        return IdleFinding.fromValue(finding);
    }

    /**
     * <p>
     * The finding classification of an idle resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #finding} will
     * return {@link IdleFinding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #findingAsString}.
     * </p>
     * 
     * @return The finding classification of an idle resource.
     * @see IdleFinding
     */
    public final String findingAsString() {
        return finding;
    }

    /**
     * <p>
     * A summary of the findings for the resource.
     * </p>
     * 
     * @return A summary of the findings for the resource.
     */
    public final String findingDescription() {
        return findingDescription;
    }

    /**
     * <p>
     * The savings opportunity for the idle resource.
     * </p>
     * 
     * @return The savings opportunity for the idle resource.
     */
    public final IdleSavingsOpportunity savingsOpportunity() {
        return savingsOpportunity;
    }

    /**
     * <p>
     * The savings opportunity for the idle resource after any applying discounts.
     * </p>
     * 
     * @return The savings opportunity for the idle resource after any applying discounts.
     */
    public final IdleSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts() {
        return savingsOpportunityAfterDiscounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the UtilizationMetrics property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUtilizationMetrics() {
        return utilizationMetrics != null && !(utilizationMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the utilization metrics of the idle resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUtilizationMetrics} method.
     * </p>
     * 
     * @return An array of objects that describe the utilization metrics of the idle resource.
     */
    public final List<IdleUtilizationMetric> utilizationMetrics() {
        return utilizationMetrics;
    }

    /**
     * <p>
     * The number of days the idle resource utilization metrics were analyzed.
     * </p>
     * 
     * @return The number of days the idle resource utilization metrics were analyzed.
     */
    public final Double lookBackPeriodInDays() {
        return lookBackPeriodInDays;
    }

    /**
     * <p>
     * The timestamp of when the idle resource recommendation was last generated.
     * </p>
     * 
     * @return The timestamp of when the idle resource recommendation was last generated.
     */
    public final Instant lastRefreshTimestamp() {
        return lastRefreshTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags assigned to your idle resource recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags assigned to your idle resource recommendations.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(findingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(findingDescription());
        hashCode = 31 * hashCode + Objects.hashCode(savingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(savingsOpportunityAfterDiscounts());
        hashCode = 31 * hashCode + Objects.hashCode(hasUtilizationMetrics() ? utilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lookBackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(lastRefreshTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdleRecommendation)) {
            return false;
        }
        IdleRecommendation other = (IdleRecommendation) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(findingAsString(), other.findingAsString())
                && Objects.equals(findingDescription(), other.findingDescription())
                && Objects.equals(savingsOpportunity(), other.savingsOpportunity())
                && Objects.equals(savingsOpportunityAfterDiscounts(), other.savingsOpportunityAfterDiscounts())
                && hasUtilizationMetrics() == other.hasUtilizationMetrics()
                && Objects.equals(utilizationMetrics(), other.utilizationMetrics())
                && Objects.equals(lookBackPeriodInDays(), other.lookBackPeriodInDays())
                && Objects.equals(lastRefreshTimestamp(), other.lastRefreshTimestamp()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdleRecommendation").add("ResourceArn", resourceArn()).add("ResourceId", resourceId())
                .add("ResourceType", resourceTypeAsString()).add("AccountId", accountId()).add("Finding", findingAsString())
                .add("FindingDescription", findingDescription()).add("SavingsOpportunity", savingsOpportunity())
                .add("SavingsOpportunityAfterDiscounts", savingsOpportunityAfterDiscounts())
                .add("UtilizationMetrics", hasUtilizationMetrics() ? utilizationMetrics() : null)
                .add("LookBackPeriodInDays", lookBackPeriodInDays()).add("LastRefreshTimestamp", lastRefreshTimestamp())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "finding":
            return Optional.ofNullable(clazz.cast(findingAsString()));
        case "findingDescription":
            return Optional.ofNullable(clazz.cast(findingDescription()));
        case "savingsOpportunity":
            return Optional.ofNullable(clazz.cast(savingsOpportunity()));
        case "savingsOpportunityAfterDiscounts":
            return Optional.ofNullable(clazz.cast(savingsOpportunityAfterDiscounts()));
        case "utilizationMetrics":
            return Optional.ofNullable(clazz.cast(utilizationMetrics()));
        case "lookBackPeriodInDays":
            return Optional.ofNullable(clazz.cast(lookBackPeriodInDays()));
        case "lastRefreshTimestamp":
            return Optional.ofNullable(clazz.cast(lastRefreshTimestamp()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("finding", FINDING_FIELD);
        map.put("findingDescription", FINDING_DESCRIPTION_FIELD);
        map.put("savingsOpportunity", SAVINGS_OPPORTUNITY_FIELD);
        map.put("savingsOpportunityAfterDiscounts", SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD);
        map.put("utilizationMetrics", UTILIZATION_METRICS_FIELD);
        map.put("lookBackPeriodInDays", LOOK_BACK_PERIOD_IN_DAYS_FIELD);
        map.put("lastRefreshTimestamp", LAST_REFRESH_TIMESTAMP_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdleRecommendation, T> g) {
        return obj -> g.apply((IdleRecommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdleRecommendation> {
        /**
         * <p>
         * The ARN of the current idle resource.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the current idle resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The unique identifier for the resource.
         * </p>
         * 
         * @param resourceId
         *        The unique identifier for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of resource that is idle.
         * </p>
         * 
         * @param resourceType
         *        The type of resource that is idle.
         * @see IdleRecommendationResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdleRecommendationResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource that is idle.
         * </p>
         * 
         * @param resourceType
         *        The type of resource that is idle.
         * @see IdleRecommendationResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdleRecommendationResourceType
         */
        Builder resourceType(IdleRecommendationResourceType resourceType);

        /**
         * <p>
         * The Amazon Web Services account ID of the idle resource.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the idle resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The finding classification of an idle resource.
         * </p>
         * 
         * @param finding
         *        The finding classification of an idle resource.
         * @see IdleFinding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdleFinding
         */
        Builder finding(String finding);

        /**
         * <p>
         * The finding classification of an idle resource.
         * </p>
         * 
         * @param finding
         *        The finding classification of an idle resource.
         * @see IdleFinding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdleFinding
         */
        Builder finding(IdleFinding finding);

        /**
         * <p>
         * A summary of the findings for the resource.
         * </p>
         * 
         * @param findingDescription
         *        A summary of the findings for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingDescription(String findingDescription);

        /**
         * <p>
         * The savings opportunity for the idle resource.
         * </p>
         * 
         * @param savingsOpportunity
         *        The savings opportunity for the idle resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsOpportunity(IdleSavingsOpportunity savingsOpportunity);

        /**
         * <p>
         * The savings opportunity for the idle resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdleSavingsOpportunity.Builder} avoiding
         * the need to create one manually via {@link IdleSavingsOpportunity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdleSavingsOpportunity.Builder#build()} is called immediately and
         * its result is passed to {@link #savingsOpportunity(IdleSavingsOpportunity)}.
         * 
         * @param savingsOpportunity
         *        a consumer that will call methods on {@link IdleSavingsOpportunity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsOpportunity(IdleSavingsOpportunity)
         */
        default Builder savingsOpportunity(Consumer<IdleSavingsOpportunity.Builder> savingsOpportunity) {
            return savingsOpportunity(IdleSavingsOpportunity.builder().applyMutation(savingsOpportunity).build());
        }

        /**
         * <p>
         * The savings opportunity for the idle resource after any applying discounts.
         * </p>
         * 
         * @param savingsOpportunityAfterDiscounts
         *        The savings opportunity for the idle resource after any applying discounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsOpportunityAfterDiscounts(IdleSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts);

        /**
         * <p>
         * The savings opportunity for the idle resource after any applying discounts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IdleSavingsOpportunityAfterDiscounts.Builder} avoiding the need to create one manually via
         * {@link IdleSavingsOpportunityAfterDiscounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdleSavingsOpportunityAfterDiscounts.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #savingsOpportunityAfterDiscounts(IdleSavingsOpportunityAfterDiscounts)}.
         * 
         * @param savingsOpportunityAfterDiscounts
         *        a consumer that will call methods on {@link IdleSavingsOpportunityAfterDiscounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsOpportunityAfterDiscounts(IdleSavingsOpportunityAfterDiscounts)
         */
        default Builder savingsOpportunityAfterDiscounts(
                Consumer<IdleSavingsOpportunityAfterDiscounts.Builder> savingsOpportunityAfterDiscounts) {
            return savingsOpportunityAfterDiscounts(IdleSavingsOpportunityAfterDiscounts.builder()
                    .applyMutation(savingsOpportunityAfterDiscounts).build());
        }

        /**
         * <p>
         * An array of objects that describe the utilization metrics of the idle resource.
         * </p>
         * 
         * @param utilizationMetrics
         *        An array of objects that describe the utilization metrics of the idle resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utilizationMetrics(Collection<IdleUtilizationMetric> utilizationMetrics);

        /**
         * <p>
         * An array of objects that describe the utilization metrics of the idle resource.
         * </p>
         * 
         * @param utilizationMetrics
         *        An array of objects that describe the utilization metrics of the idle resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utilizationMetrics(IdleUtilizationMetric... utilizationMetrics);

        /**
         * <p>
         * An array of objects that describe the utilization metrics of the idle resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.IdleUtilizationMetric.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.IdleUtilizationMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.IdleUtilizationMetric.Builder#build()} is
         * called immediately and its result is passed to {@link #utilizationMetrics(List<IdleUtilizationMetric>)}.
         * 
         * @param utilizationMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.IdleUtilizationMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #utilizationMetrics(java.util.Collection<IdleUtilizationMetric>)
         */
        Builder utilizationMetrics(Consumer<IdleUtilizationMetric.Builder>... utilizationMetrics);

        /**
         * <p>
         * The number of days the idle resource utilization metrics were analyzed.
         * </p>
         * 
         * @param lookBackPeriodInDays
         *        The number of days the idle resource utilization metrics were analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookBackPeriodInDays(Double lookBackPeriodInDays);

        /**
         * <p>
         * The timestamp of when the idle resource recommendation was last generated.
         * </p>
         * 
         * @param lastRefreshTimestamp
         *        The timestamp of when the idle resource recommendation was last generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRefreshTimestamp(Instant lastRefreshTimestamp);

        /**
         * <p>
         * A list of tags assigned to your idle resource recommendations.
         * </p>
         * 
         * @param tags
         *        A list of tags assigned to your idle resource recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags assigned to your idle resource recommendations.
         * </p>
         * 
         * @param tags
         *        A list of tags assigned to your idle resource recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags assigned to your idle resource recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.computeoptimizer.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String resourceId;

        private String resourceType;

        private String accountId;

        private String finding;

        private String findingDescription;

        private IdleSavingsOpportunity savingsOpportunity;

        private IdleSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

        private List<IdleUtilizationMetric> utilizationMetrics = DefaultSdkAutoConstructList.getInstance();

        private Double lookBackPeriodInDays;

        private Instant lastRefreshTimestamp;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IdleRecommendation model) {
            resourceArn(model.resourceArn);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            accountId(model.accountId);
            finding(model.finding);
            findingDescription(model.findingDescription);
            savingsOpportunity(model.savingsOpportunity);
            savingsOpportunityAfterDiscounts(model.savingsOpportunityAfterDiscounts);
            utilizationMetrics(model.utilizationMetrics);
            lookBackPeriodInDays(model.lookBackPeriodInDays);
            lastRefreshTimestamp(model.lastRefreshTimestamp);
            tags(model.tags);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IdleRecommendationResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getFinding() {
            return finding;
        }

        public final void setFinding(String finding) {
            this.finding = finding;
        }

        @Override
        public final Builder finding(String finding) {
            this.finding = finding;
            return this;
        }

        @Override
        public final Builder finding(IdleFinding finding) {
            this.finding(finding == null ? null : finding.toString());
            return this;
        }

        public final String getFindingDescription() {
            return findingDescription;
        }

        public final void setFindingDescription(String findingDescription) {
            this.findingDescription = findingDescription;
        }

        @Override
        public final Builder findingDescription(String findingDescription) {
            this.findingDescription = findingDescription;
            return this;
        }

        public final IdleSavingsOpportunity.Builder getSavingsOpportunity() {
            return savingsOpportunity != null ? savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(IdleSavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(IdleSavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public final IdleSavingsOpportunityAfterDiscounts.Builder getSavingsOpportunityAfterDiscounts() {
            return savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts.toBuilder() : null;
        }

        public final void setSavingsOpportunityAfterDiscounts(
                IdleSavingsOpportunityAfterDiscounts.BuilderImpl savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts
                    .build() : null;
        }

        @Override
        public final Builder savingsOpportunityAfterDiscounts(
                IdleSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts;
            return this;
        }

        public final List<IdleUtilizationMetric.Builder> getUtilizationMetrics() {
            List<IdleUtilizationMetric.Builder> result = IdleUtilizationMetricsCopier.copyToBuilder(this.utilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtilizationMetrics(Collection<IdleUtilizationMetric.BuilderImpl> utilizationMetrics) {
            this.utilizationMetrics = IdleUtilizationMetricsCopier.copyFromBuilder(utilizationMetrics);
        }

        @Override
        public final Builder utilizationMetrics(Collection<IdleUtilizationMetric> utilizationMetrics) {
            this.utilizationMetrics = IdleUtilizationMetricsCopier.copy(utilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(IdleUtilizationMetric... utilizationMetrics) {
            utilizationMetrics(Arrays.asList(utilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(Consumer<IdleUtilizationMetric.Builder>... utilizationMetrics) {
            utilizationMetrics(Stream.of(utilizationMetrics).map(c -> IdleUtilizationMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Double getLookBackPeriodInDays() {
            return lookBackPeriodInDays;
        }

        public final void setLookBackPeriodInDays(Double lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
        }

        @Override
        public final Builder lookBackPeriodInDays(Double lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
            return this;
        }

        public final Instant getLastRefreshTimestamp() {
            return lastRefreshTimestamp;
        }

        public final void setLastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
        }

        @Override
        public final Builder lastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public IdleRecommendation build() {
            return new IdleRecommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
