/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdleRecommendationsRequest extends ComputeOptimizerRequest implements
        ToCopyableBuilder<GetIdleRecommendationsRequest.Builder, GetIdleRecommendationsRequest> {
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceArns")
            .getter(getter(GetIdleRecommendationsRequest::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetIdleRecommendationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetIdleRecommendationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<IdleRecommendationFilter>> FILTERS_FIELD = SdkField
            .<List<IdleRecommendationFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(GetIdleRecommendationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdleRecommendationFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdleRecommendationFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(GetIdleRecommendationsRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OrderBy> ORDER_BY_FIELD = SdkField.<OrderBy> builder(MarshallingType.SDK_POJO)
            .memberName("orderBy").getter(getter(GetIdleRecommendationsRequest::orderBy)).setter(setter(Builder::orderBy))
            .constructor(OrderBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARNS_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD, ACCOUNT_IDS_FIELD, ORDER_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> resourceArns;

    private final String nextToken;

    private final Integer maxResults;

    private final List<IdleRecommendationFilter> filters;

    private final List<String> accountIds;

    private final OrderBy orderBy;

    private GetIdleRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArns = builder.resourceArns;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.accountIds = builder.accountIds;
        this.orderBy = builder.orderBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN that identifies the idle resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceArns} method.
     * </p>
     * 
     * @return The ARN that identifies the idle resource.
     */
    public final List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * <p>
     * The token to advance to the next page of idle resource recommendations.
     * </p>
     * 
     * @return The token to advance to the next page of idle resource recommendations.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of idle resource recommendations to return with a single request.
     * </p>
     * <p>
     * To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of idle resource recommendations to return with a single request. </p>
     *         <p>
     *         To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects to specify a filter that returns a more specific list of idle resource recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return An array of objects to specify a filter that returns a more specific list of idle resource
     *         recommendations.
     */
    public final List<IdleRecommendationFilter> filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Return the idle resource recommendations to the specified Amazon Web Services account IDs.
     * </p>
     * <p>
     * If your account is the management account or the delegated administrator of an organization, use this parameter
     * to return the idle resource recommendations to specific member accounts.
     * </p>
     * <p>
     * You can only specify one account ID per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return Return the idle resource recommendations to the specified Amazon Web Services account IDs.</p>
     *         <p>
     *         If your account is the management account or the delegated administrator of an organization, use this
     *         parameter to return the idle resource recommendations to specific member accounts.
     *         </p>
     *         <p>
     *         You can only specify one account ID per request.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * <p>
     * The order to sort the idle resource recommendations.
     * </p>
     * 
     * @return The order to sort the idle resource recommendations.
     */
    public final OrderBy orderBy() {
        return orderBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceArns() ? resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(orderBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdleRecommendationsRequest)) {
            return false;
        }
        GetIdleRecommendationsRequest other = (GetIdleRecommendationsRequest) obj;
        return hasResourceArns() == other.hasResourceArns() && Objects.equals(resourceArns(), other.resourceArns())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && Objects.equals(orderBy(), other.orderBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIdleRecommendationsRequest").add("ResourceArns", hasResourceArns() ? resourceArns() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("Filters", hasFilters() ? filters() : null)
                .add("AccountIds", hasAccountIds() ? accountIds() : null).add("OrderBy", orderBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "orderBy":
            return Optional.ofNullable(clazz.cast(orderBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceArns", RESOURCE_ARNS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("orderBy", ORDER_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdleRecommendationsRequest, T> g) {
        return obj -> g.apply((GetIdleRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComputeOptimizerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIdleRecommendationsRequest> {
        /**
         * <p>
         * The ARN that identifies the idle resource.
         * </p>
         * 
         * @param resourceArns
         *        The ARN that identifies the idle resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * The ARN that identifies the idle resource.
         * </p>
         * 
         * @param resourceArns
         *        The ARN that identifies the idle resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * <p>
         * The token to advance to the next page of idle resource recommendations.
         * </p>
         * 
         * @param nextToken
         *        The token to advance to the next page of idle resource recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of idle resource recommendations to return with a single request.
         * </p>
         * <p>
         * To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of idle resource recommendations to return with a single request. </p>
         *        <p>
         *        To retrieve the remaining results, make another request with the returned <code>nextToken</code>
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of idle resource recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects to specify a filter that returns a more specific list of idle resource
         *        recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<IdleRecommendationFilter> filters);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of idle resource recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects to specify a filter that returns a more specific list of idle resource
         *        recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(IdleRecommendationFilter... filters);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of idle resource recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendationFilter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendationFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendationFilter.Builder#build()} is
         * called immediately and its result is passed to {@link #filters(List<IdleRecommendationFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendationFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<IdleRecommendationFilter>)
         */
        Builder filters(Consumer<IdleRecommendationFilter.Builder>... filters);

        /**
         * <p>
         * Return the idle resource recommendations to the specified Amazon Web Services account IDs.
         * </p>
         * <p>
         * If your account is the management account or the delegated administrator of an organization, use this
         * parameter to return the idle resource recommendations to specific member accounts.
         * </p>
         * <p>
         * You can only specify one account ID per request.
         * </p>
         * 
         * @param accountIds
         *        Return the idle resource recommendations to the specified Amazon Web Services account IDs.</p>
         *        <p>
         *        If your account is the management account or the delegated administrator of an organization, use this
         *        parameter to return the idle resource recommendations to specific member accounts.
         *        </p>
         *        <p>
         *        You can only specify one account ID per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * Return the idle resource recommendations to the specified Amazon Web Services account IDs.
         * </p>
         * <p>
         * If your account is the management account or the delegated administrator of an organization, use this
         * parameter to return the idle resource recommendations to specific member accounts.
         * </p>
         * <p>
         * You can only specify one account ID per request.
         * </p>
         * 
         * @param accountIds
         *        Return the idle resource recommendations to the specified Amazon Web Services account IDs.</p>
         *        <p>
         *        If your account is the management account or the delegated administrator of an organization, use this
         *        parameter to return the idle resource recommendations to specific member accounts.
         *        </p>
         *        <p>
         *        You can only specify one account ID per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * The order to sort the idle resource recommendations.
         * </p>
         * 
         * @param orderBy
         *        The order to sort the idle resource recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderBy(OrderBy orderBy);

        /**
         * <p>
         * The order to sort the idle resource recommendations.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrderBy.Builder} avoiding the need to
         * create one manually via {@link OrderBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrderBy.Builder#build()} is called immediately and its result is
         * passed to {@link #orderBy(OrderBy)}.
         * 
         * @param orderBy
         *        a consumer that will call methods on {@link OrderBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderBy(OrderBy)
         */
        default Builder orderBy(Consumer<OrderBy.Builder> orderBy) {
            return orderBy(OrderBy.builder().applyMutation(orderBy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComputeOptimizerRequest.BuilderImpl implements Builder {
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private List<IdleRecommendationFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private OrderBy orderBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdleRecommendationsRequest model) {
            super(model);
            resourceArns(model.resourceArns);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
            accountIds(model.accountIds);
            orderBy(model.orderBy);
        }

        public final Collection<String> getResourceArns() {
            if (resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<IdleRecommendationFilter.Builder> getFilters() {
            List<IdleRecommendationFilter.Builder> result = IdleRecommendationFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<IdleRecommendationFilter.BuilderImpl> filters) {
            this.filters = IdleRecommendationFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<IdleRecommendationFilter> filters) {
            this.filters = IdleRecommendationFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(IdleRecommendationFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<IdleRecommendationFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> IdleRecommendationFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final OrderBy.Builder getOrderBy() {
            return orderBy != null ? orderBy.toBuilder() : null;
        }

        public final void setOrderBy(OrderBy.BuilderImpl orderBy) {
            this.orderBy = orderBy != null ? orderBy.build() : null;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIdleRecommendationsRequest build() {
            return new GetIdleRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
