/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerResponse;
import software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendation;
import software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendationError;
import software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendationErrorsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdleRecommendationsResponse
extends ComputeOptimizerResponse
implements ToCopyableBuilder<Builder, GetIdleRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetIdleRecommendationsResponse.getter(GetIdleRecommendationsResponse::nextToken)).setter(GetIdleRecommendationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<IdleRecommendation>> IDLE_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("idleRecommendations").getter(GetIdleRecommendationsResponse.getter(GetIdleRecommendationsResponse::idleRecommendations)).setter(GetIdleRecommendationsResponse.setter(Builder::idleRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdleRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<IdleRecommendationError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(GetIdleRecommendationsResponse.getter(GetIdleRecommendationsResponse::errors)).setter(GetIdleRecommendationsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdleRecommendationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, IDLE_RECOMMENDATIONS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIdleRecommendationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<IdleRecommendation> idleRecommendations;
    private final List<IdleRecommendationError> errors;

    private GetIdleRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.idleRecommendations = builder.idleRecommendations;
        this.errors = builder.errors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasIdleRecommendations() {
        return this.idleRecommendations != null && !(this.idleRecommendations instanceof SdkAutoConstructList);
    }

    public final List<IdleRecommendation> idleRecommendations() {
        return this.idleRecommendations;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<IdleRecommendationError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdleRecommendations() ? this.idleRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdleRecommendationsResponse)) {
            return false;
        }
        GetIdleRecommendationsResponse other = (GetIdleRecommendationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasIdleRecommendations() == other.hasIdleRecommendations() && Objects.equals(this.idleRecommendations(), other.idleRecommendations()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"GetIdleRecommendationsResponse").add("NextToken", (Object)this.nextToken()).add("IdleRecommendations", this.hasIdleRecommendations() ? this.idleRecommendations() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "idleRecommendations": {
                return Optional.ofNullable(clazz.cast(this.idleRecommendations()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("idleRecommendations", IDLE_RECOMMENDATIONS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdleRecommendationsResponse, T> g) {
        return obj -> g.apply((GetIdleRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<IdleRecommendation> idleRecommendations = DefaultSdkAutoConstructList.getInstance();
        private List<IdleRecommendationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdleRecommendationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.idleRecommendations(model.idleRecommendations);
            this.errors(model.errors);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<IdleRecommendation.Builder> getIdleRecommendations() {
            List<IdleRecommendation.Builder> result = IdleRecommendationsCopier.copyToBuilder(this.idleRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdleRecommendations(Collection<IdleRecommendation.BuilderImpl> idleRecommendations) {
            this.idleRecommendations = IdleRecommendationsCopier.copyFromBuilder(idleRecommendations);
        }

        @Override
        public final Builder idleRecommendations(Collection<IdleRecommendation> idleRecommendations) {
            this.idleRecommendations = IdleRecommendationsCopier.copy(idleRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idleRecommendations(IdleRecommendation ... idleRecommendations) {
            this.idleRecommendations(Arrays.asList(idleRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idleRecommendations(Consumer<IdleRecommendation.Builder> ... idleRecommendations) {
            this.idleRecommendations(Stream.of(idleRecommendations).map(c -> (IdleRecommendation)((IdleRecommendation.Builder)IdleRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<IdleRecommendationError.Builder> getErrors() {
            List<IdleRecommendationError.Builder> result = IdleRecommendationErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<IdleRecommendationError.BuilderImpl> errors) {
            this.errors = IdleRecommendationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<IdleRecommendationError> errors) {
            this.errors = IdleRecommendationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(IdleRecommendationError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<IdleRecommendationError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (IdleRecommendationError)((IdleRecommendationError.Builder)IdleRecommendationError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetIdleRecommendationsResponse build() {
            return new GetIdleRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComputeOptimizerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdleRecommendationsResponse> {
        public Builder nextToken(String var1);

        public Builder idleRecommendations(Collection<IdleRecommendation> var1);

        public Builder idleRecommendations(IdleRecommendation ... var1);

        public Builder idleRecommendations(Consumer<IdleRecommendation.Builder> ... var1);

        public Builder errors(Collection<IdleRecommendationError> var1);

        public Builder errors(IdleRecommendationError ... var1);

        public Builder errors(Consumer<IdleRecommendationError.Builder> ... var1);
    }
}

