/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceSavingsEstimationModeSource {
    PUBLIC_PRICING("PublicPricing"),
    COST_EXPLORER_RIGHTSIZING("CostExplorerRightsizing"),
    COST_OPTIMIZATION_HUB("CostOptimizationHub"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceSavingsEstimationModeSource> VALUE_MAP;
    private final String value;

    private InstanceSavingsEstimationModeSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceSavingsEstimationModeSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceSavingsEstimationModeSource> knownValues() {
        EnumSet<InstanceSavingsEstimationModeSource> knownValues = EnumSet.allOf(InstanceSavingsEstimationModeSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceSavingsEstimationModeSource.class, InstanceSavingsEstimationModeSource::toString);
    }
}

